/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.util.Objects;
import org.jboss.as.repository.HashUtil;

public class ContentReference {
    private final String contentIdentifier;
    private final String hexHash;

    public ContentReference(String contentIdentifier, String hexHash) {
        this.contentIdentifier = contentIdentifier;
        this.hexHash = hexHash == null ? "" : hexHash;
    }

    public ContentReference(String contentIdentifier, byte[] hash) {
        this(contentIdentifier, hash, System.currentTimeMillis());
    }

    public ContentReference(String contentIdentifier, byte[] hash, long timestamp) {
        this.contentIdentifier = contentIdentifier;
        this.hexHash = hash == null || hash.length == 0 ? "" : HashUtil.bytesToHexString(hash);
    }

    public String getContentIdentifier() {
        return this.contentIdentifier;
    }

    public String getHexHash() {
        return this.hexHash;
    }

    public byte[] getHash() {
        if (this.hexHash.isEmpty()) {
            return new byte[0];
        }
        return HashUtil.hexStringToByteArray(this.hexHash);
    }

    public int hashCode() {
        int hashCode = 7;
        hashCode = 43 * hashCode + Objects.hashCode(this.contentIdentifier);
        hashCode = 43 * hashCode + Objects.hashCode(this.hexHash);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentReference other = (ContentReference)obj;
        if (!Objects.equals(this.contentIdentifier, other.contentIdentifier)) {
            return false;
        }
        return Objects.equals(this.hexHash, other.hexHash);
    }

    public String toString() {
        return "ContentReference{contentIdentifier=" + this.contentIdentifier + ", hexHash=" + this.hexHash + "}";
    }
}

