/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import org.apache.lucene.index.SortedSetDocValues;

public abstract class TextMultiValues {
    public static final TextMultiValues EMPTY = new TextMultiValues(){

        @Override
        public boolean advanceExact(int doc) {
            return false;
        }

        @Override
        public boolean hasNextValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long nextOrd() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getValueCount() {
            return 0L;
        }
    };

    protected TextMultiValues() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract boolean hasNextValue() throws IOException;

    public abstract long nextOrd() throws IOException;

    public abstract long getValueCount();

    public static TextMultiValues fromDocValues(SortedSetDocValues docValues) {
        return new DocValuesTextMultiValues(docValues);
    }

    protected static class DocValuesTextMultiValues
    extends TextMultiValues {
        protected final SortedSetDocValues values;
        protected long nextOrd;

        DocValuesTextMultiValues(SortedSetDocValues values) {
            this.values = values;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            boolean found = this.values.advanceExact(doc);
            this.nextOrd = found ? this.values.nextOrd() : -1L;
            return found;
        }

        @Override
        public boolean hasNextValue() throws IOException {
            return this.nextOrd != -1L;
        }

        @Override
        public long nextOrd() throws IOException {
            long result = this.nextOrd;
            this.nextOrd = this.values.nextOrd();
            return result;
        }

        @Override
        public long getValueCount() {
            return this.values.getValueCount();
        }
    }
}

