/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Methods;
import java.io.IOException;
import java.util.function.Function;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.OperationParameter;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.domain.http.server.security.RealmReadinessHandler;
import org.jboss.dmr.ModelNode;

public class DmrFailureReadinessHandler
extends RealmReadinessHandler {
    private final String redirectTo;

    public DmrFailureReadinessHandler(Function<HttpServerExchange, Boolean> readyFunction, HttpHandler next, String redirectTo) {
        super(readyFunction, next);
        this.redirectTo = redirectTo;
    }

    @Override
    void rejectRequest(HttpServerExchange exchange) throws IOException {
        ModelNode rejection = new ModelNode();
        rejection.get("outcome").set("failed");
        rejection.get("failure-description").set(HttpServerLogger.ROOT_LOGGER.realmNotReadyMessage(DomainUtil.constructUrl(exchange, this.redirectTo)));
        rejection.get("rolled-back").set(Boolean.TRUE.toString());
        boolean get = exchange.getRequestMethod().equals(Methods.GET);
        OperationParameter operationParameter = new OperationParameter.Builder(get).encode(false).pretty(true).build();
        DomainUtil.writeResponse(exchange, 403, rejection, operationParameter);
    }
}

