/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import jakarta.transaction.Transaction;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.DiscoveryEJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteTransaction;

@ClientInterceptorPriority(value=-200000)
public final class TransactionInterceptor
implements EJBClientInterceptor {
    private static final ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
    static final Object RESOURCE_KEY = new Object();
    static final AttachmentKey<Collection<URI>> PREFERRED_DESTINATIONS = new AttachmentKey();
    static final AttachmentKey<ConcurrentMap<Application, URI>> APPLICATIONS = new AttachmentKey();
    public static final int PRIORITY = -200000;

    private static URI getApplicationAssociation(ConcurrentMap<Application, URI> applications, AbstractInvocationContext context) {
        return (URI)applications.get(TransactionInterceptor.toApplication(context.getLocator().getIdentifier()));
    }

    static Application toApplication(EJBIdentifier id) {
        return new Application(id.getAppName(), id.getModuleName(), id.getDistinctName());
    }

    private static ConcurrentMap<Application, URI> getOrCreateApplicationMap(AbstractTransaction transaction) {
        Object resource = transaction.getResource(RESOURCE_KEY);
        ConcurrentHashMap<Application, URI> map = null;
        if (resource == null) {
            map = new ConcurrentHashMap<Application, URI>();
            resource = transaction.putResourceIfAbsent(RESOURCE_KEY, map);
        }
        return resource == null ? map : (ConcurrentMap)ConcurrentMap.class.cast(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        AbstractTransaction transaction = context.getTransaction();
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: Calling  handleSessionCreation: context transaction = %s", transaction);
        }
        if (transaction == null) {
            transaction = transactionManager.getTransaction();
            context.setTransaction(transaction);
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: Calling  handleSessionCreation: setting context transaction to caller transaction: caller transaction = %s", transaction);
            }
        }
        this.setupStickinessIfRequired(context, true, transaction);
        AbstractTransaction old = transactionManager.suspend();
        try {
            SessionID sessionID = context.proceed();
            return sessionID;
        }
        finally {
            transactionManager.resume((Transaction)old);
        }
    }

    private void setupSessionAffinitiesIfNeeded(AbstractInvocationContext context) {
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: calling DiscoveryEJBClientInterceptor.setupSessionAffinitiesIfNeeded", new Object[0]);
        }
        if (context instanceof EJBSessionCreationInvocationContext) {
            DiscoveryEJBClientInterceptor.setupSessionAffinities((EJBSessionCreationInvocationContext)context);
        }
    }

    private void setupStickinessIfRequired(AbstractInvocationContext context, boolean propagate, AbstractTransaction transaction) {
        ConcurrentMap<Application, URI> applications = null;
        if (transaction instanceof RemoteTransaction) {
            URI location = ((RemoteTransaction)transaction).getLocation();
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: calling setupStickinessIfRequired with RemoteTransaction, transaction location = %s", location);
            }
            if (location != null) {
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: setting destination = %s", location);
                }
                context.setDestination(location);
                this.setupSessionAffinitiesIfNeeded(context);
            }
        } else if (transaction instanceof LocalTransaction && propagate) {
            applications = TransactionInterceptor.getOrCreateApplicationMap(transaction);
            URI destination = TransactionInterceptor.getApplicationAssociation(applications, context);
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: calling setupStickinessIfRequired with LocalTransaction, application map = %s, application destination = %s", applications, destination);
            }
            if (destination != null) {
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: setting destination = %s", destination);
                }
                context.setDestination(destination);
                this.setupSessionAffinitiesIfNeeded(context);
            } else {
                if (applications.size() > 0) {
                    if (Logs.INVOCATION.isDebugEnabled()) {
                        Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: setting preferred destinations using map = %s", applications);
                    }
                    context.putAttachment(PREFERRED_DESTINATIONS, applications.values());
                }
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: setting applications attachment using map = %s", applications);
                }
                context.putAttachment(APPLICATIONS, applications);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        ClientTransactionPolicy transactionPolicy = context.getTransactionPolicy();
        AbstractTransaction transaction = context.getTransaction();
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: calling handleInvocation, context transaction = %s, transaction policy = %s", transaction, (Object)transactionPolicy);
        }
        if (transaction == null) {
            transaction = transactionManager.getTransaction();
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: calling handleInvocation, no context transaction; using caller transaction = %s", transaction);
            }
        }
        this.setupStickinessIfRequired(context, transactionPolicy.propagate(), transaction);
        if (transactionPolicy.failIfTransactionAbsent() && transaction == null) {
            throw Logs.TXN.txNotActiveForThread();
        }
        if (transactionPolicy.failIfTransactionPresent() && transaction != null) {
            throw Logs.TXN.txAlreadyAssociatedWithThread();
        }
        if (transactionPolicy.propagate()) {
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("TransactionEJBClientInterceptor: Calling  handleInvocation: setting context transaction: transaction = %s", transaction);
            }
            context.setTransaction(transaction);
        }
        AbstractTransaction old = transactionManager.suspend();
        try {
            context.sendRequest();
        }
        finally {
            transactionManager.resume((Transaction)old);
        }
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        return context.getResult();
    }

    static final class Application {
        private String application;
        private String distinctName;

        public Application(String application, String moduleName, String distinctName) {
            this.application = application.isEmpty() ? moduleName : application;
            this.distinctName = distinctName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Application)) {
                return false;
            }
            Application that = (Application)o;
            return this.application.equals(that.application) && this.distinctName.equals(that.distinctName);
        }

        public int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + this.distinctName.hashCode();
            return result;
        }

        public String toString() {
            return "Application{application='" + this.application + '\'' + ", distinctName='" + this.distinctName + '\'' + '}';
        }
    }
}

