/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.provider;

public class HttpResponseException
extends Error {
    private int expectedResponse;
    private int actualResponse;
    private String body;

    public HttpResponseException(Throwable cause, String body, int expectedResponse, int actualResponse) {
        super(cause);
        this.body = body;
        this.expectedResponse = expectedResponse;
        this.actualResponse = actualResponse;
    }

    public HttpResponseException(Throwable cause, String body, int[] expectedResponses, int actualResponse) {
        this(cause, body, expectedResponses != null && expectedResponses.length != 0 ? expectedResponses[0] : -1, actualResponse);
    }

    public HttpResponseException(int expectedResponse, int actualResponse) {
        this(null, null, expectedResponse, actualResponse);
    }

    public int getExpectedResponse() {
        return this.expectedResponse;
    }

    public int getActualResponse() {
        return this.actualResponse;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getMessage() {
        if (this.getCause() != null) {
            return super.getMessage();
        }
        if (this.expectedResponse != this.actualResponse) {
            return "Unexpected status. Expected " + this.expectedResponse + " got " + this.actualResponse;
        }
        throw new Error("Invalid HttpResponseException thrown - there's no error and status is fine");
    }
}

