/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.AbstractVirtualFileFilterWithAttributes;

public class SuffixMatchFilter
extends AbstractVirtualFileFilterWithAttributes {
    private static Logger log = Logger.getLogger(SuffixMatchFilter.class);
    private Collection<String> suffixes;
    private boolean trace;

    public SuffixMatchFilter(String suffix) {
        this(suffix, null);
    }

    public SuffixMatchFilter(String suffix, VisitorAttributes attributes) {
        this(Collections.singleton(suffix), attributes);
    }

    public SuffixMatchFilter(Collection<String> suffixes) {
        this(suffixes, null);
    }

    public SuffixMatchFilter(Collection<String> suffixes, VisitorAttributes attributes) {
        super(attributes == null ? VisitorAttributes.DEFAULT : attributes);
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffixes");
        }
        this.suffixes = new LinkedHashSet<String>();
        this.suffixes.addAll(suffixes);
        this.trace = log.isTraceEnabled();
    }

    @Override
    public boolean accepts(VirtualFile file) {
        String name = file.getName();
        boolean accepts = false;
        for (String suffix : this.suffixes) {
            if (!name.endsWith(suffix)) continue;
            accepts = true;
            break;
        }
        if (this.trace) {
            log.trace(file + " accepted: " + accepts);
        }
        return accepts;
    }
}

