/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Buffers;
import org.xnio.Pooled;
import org.xnio.conduits.AbstractSinkConduit;
import org.xnio.conduits.MessageSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public final class FramingMessageSinkConduit
extends AbstractSinkConduit<StreamSinkConduit>
implements MessageSinkConduit {
    private final boolean longLengths;
    private final Pooled<ByteBuffer> transmitBuffer;

    public FramingMessageSinkConduit(StreamSinkConduit next, boolean longLengths, Pooled<ByteBuffer> transmitBuffer) {
        super(next);
        this.longLengths = longLengths;
        this.transmitBuffer = transmitBuffer;
    }

    @Override
    public boolean send(ByteBuffer src) throws IOException {
        int lengthFieldSize;
        ByteBuffer buffer = this.transmitBuffer.getResource();
        if (!buffer.hasRemaining()) {
            return false;
        }
        ByteBuffer transmitBuffer = this.transmitBuffer.getResource();
        int remaining = buffer.remaining();
        boolean longLengths = this.longLengths;
        int n = lengthFieldSize = longLengths ? 4 : 2;
        if (remaining > transmitBuffer.capacity() - lengthFieldSize || !longLengths && remaining > 65535) {
            throw new IOException("Transmitted message is too large");
        }
        if (transmitBuffer.remaining() < lengthFieldSize + remaining && !this.writeBuffer()) {
            return false;
        }
        if (longLengths) {
            transmitBuffer.putInt(remaining);
        } else {
            transmitBuffer.putShort((short)remaining);
        }
        transmitBuffer.put(buffer);
        this.writeBuffer();
        return true;
    }

    @Override
    public boolean send(ByteBuffer[] srcs, int offs, int len) throws IOException {
        int lengthFieldSize;
        if (len == 1) {
            return this.send(srcs[offs]);
        }
        if (!Buffers.hasRemaining(srcs, offs, len)) {
            return false;
        }
        ByteBuffer transmitBuffer = this.transmitBuffer.getResource();
        long remaining = Buffers.remaining(srcs, offs, len);
        boolean longLengths = this.longLengths;
        int n = lengthFieldSize = longLengths ? 4 : 2;
        if (remaining > (long)(transmitBuffer.capacity() - lengthFieldSize) || !longLengths && remaining > 65535L) {
            throw new IOException("Transmitted message is too large");
        }
        if ((long)transmitBuffer.remaining() < (long)lengthFieldSize + remaining && !this.writeBuffer()) {
            return false;
        }
        if (longLengths) {
            transmitBuffer.putInt((int)remaining);
        } else {
            transmitBuffer.putShort((short)remaining);
        }
        Buffers.copy(transmitBuffer, srcs, offs, len);
        this.writeBuffer();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeBuffer() throws IOException {
        ByteBuffer buffer = this.transmitBuffer.getResource();
        if (buffer.position() > 0) {
            buffer.flip();
        }
        try {
            while (buffer.hasRemaining()) {
                int res = ((StreamSinkConduit)this.next).write(buffer);
                if (res != 0) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            buffer.compact();
        }
    }

    @Override
    public boolean flush() throws IOException {
        return this.writeBuffer() && ((StreamSinkConduit)this.next).flush();
    }

    @Override
    public void terminateWrites() throws IOException {
        this.transmitBuffer.free();
        ((StreamSinkConduit)this.next).terminateWrites();
    }

    @Override
    public void truncateWrites() throws IOException {
        this.transmitBuffer.free();
        ((StreamSinkConduit)this.next).truncateWrites();
    }
}

