/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.web.CatalinaMessages;

public class SSLAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.SSLAuthenticator/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        X509Certificate[] certs = request.getCertificateChain();
        if (certs == null || certs.length < 1) {
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)"  No certificates included with this request");
            }
            response.sendError(401, CatalinaMessages.MESSAGES.missingRequestCertificate());
            return false;
        }
        principal = this.context.getRealm().authenticate(certs);
        if (principal == null) {
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)"  Realm.authenticate() returned false");
            }
            response.sendError(401, CatalinaMessages.MESSAGES.certificateAuthenticationFailure());
            return false;
        }
        this.register(request, response, principal, "CLIENT_CERT", null, null);
        return true;
    }

    @Override
    public void start() throws LifecycleException {
        super.start();
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
    }
}

