/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.jboss.web.CatalinaMessages;

public class ConnectorMBean
extends BaseModelMBean {
    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(CatalinaMessages.MESSAGES.invalidNullAttributeName());
        }
        Object result = null;
        try {
            Connector connector = (Connector)this.getManagedResource();
            result = IntrospectionUtils.getProperty(connector, name);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(CatalinaMessages.MESSAGES.invalidNullAttribute());
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(CatalinaMessages.MESSAGES.invalidNullAttributeName());
        }
        try {
            Connector connector = (Connector)this.getManagedResource();
            IntrospectionUtils.setProperty(connector, name, String.valueOf(value));
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public String getClassName() {
        return this.resource.getClass().getName();
    }
}

