/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.Context;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.Multipart;
import org.jboss.web.CatalinaMessages;

public class StandardWrapperFacade
implements ServletRegistration,
ServletConfig {
    private StandardWrapper wrapper = null;
    private ServletContext context = null;

    public StandardWrapperFacade(StandardWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public String getServletName() {
        return this.wrapper.getServletName();
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = this.wrapper.getServletContext();
            if (this.context != null && this.context instanceof ApplicationContext) {
                this.context = ((ApplicationContext)this.context).getFacade();
            }
        }
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.wrapper.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.wrapper.getInitParameterNames();
    }

    public Set<String> addMapping(String ... urlPatterns) {
        HashSet<String> conflicts = new HashSet<String>();
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw CatalinaMessages.MESSAGES.invalidServletRegistrationArguments();
        }
        for (String urlPattern : urlPatterns) {
            if (((Context)this.wrapper.getParent()).findServletMapping(urlPattern) == null) continue;
            conflicts.add(urlPattern);
        }
        if (conflicts.isEmpty()) {
            for (String urlPattern : urlPatterns) {
                ((Context)this.wrapper.getParent()).addServletMapping(urlPattern, this.wrapper.getName());
            }
        }
        return conflicts;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        this.wrapper.setAsyncSupported(asyncSupported);
    }

    public void setDescription(String description) {
        this.wrapper.setDescription(description);
    }

    public boolean setInitParameter(String name, String value) {
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        if (name == null || value == null) {
            throw CatalinaMessages.MESSAGES.invalidServletRegistrationArguments();
        }
        if (this.wrapper.findInitParameter(name) == null) {
            this.wrapper.addInitParameter(name, value);
            return true;
        }
        return false;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        if (initParameters == null) {
            throw CatalinaMessages.MESSAGES.invalidServletRegistrationArguments();
        }
        HashSet<String> conflicts = new HashSet<String>();
        for (String parameterName : initParameters.keySet()) {
            if (this.wrapper.findInitParameter(parameterName) != null) {
                conflicts.add(parameterName);
                continue;
            }
            String value = initParameters.get(parameterName);
            if (value == null) {
                throw CatalinaMessages.MESSAGES.invalidServletRegistrationArguments();
            }
            this.wrapper.addInitParameter(parameterName, value);
        }
        return conflicts;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        this.wrapper.setLoadOnStartup(loadOnStartup);
    }

    public Collection<String> getMappings() {
        HashSet<String> result = new HashSet<String>();
        String[] mappings = this.wrapper.findMappings();
        for (int i = 0; i < mappings.length; ++i) {
            result.add(mappings[i]);
        }
        return Collections.unmodifiableSet(result);
    }

    public String getClassName() {
        return this.wrapper.getServletClass();
    }

    public Map<String, String> getInitParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] names = this.wrapper.findInitParameters();
        for (int i = 0; i < names.length; ++i) {
            result.put(names[i], this.wrapper.getInitParameter(names[i]));
        }
        return Collections.unmodifiableMap(result);
    }

    public String getName() {
        return this.wrapper.getName();
    }

    public String getRunAsRole() {
        return this.wrapper.getRunAs();
    }

    public void setRunAsRole(String roleName) {
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        if (roleName == null) {
            throw CatalinaMessages.MESSAGES.invalidServletRegistrationArguments();
        }
        this.wrapper.setRunAs(roleName);
    }

    public Set<String> setServletSecurity(ServletSecurityElement servletSecurity) {
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        if (servletSecurity == null) {
            throw CatalinaMessages.MESSAGES.invalidServletRegistrationArguments();
        }
        return this.wrapper.setServletSecurity(servletSecurity);
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        if (!((Context)this.wrapper.getParent()).isStarting()) {
            throw CatalinaMessages.MESSAGES.cannotAddServletRegistrationAfterInit(((Context)this.wrapper.getParent()).getPath());
        }
        if (multipartConfig == null) {
            throw CatalinaMessages.MESSAGES.invalidServletRegistrationArguments();
        }
        Multipart multipart = new Multipart();
        multipart.setLocation(multipartConfig.getLocation());
        multipart.setMaxFileSize(multipartConfig.getMaxFileSize());
        multipart.setMaxRequestSize(multipartConfig.getMaxRequestSize());
        multipart.setFileSizeThreshold(multipartConfig.getFileSizeThreshold());
        this.wrapper.setMultipartConfig(multipart);
    }

    public static class Dynamic
    extends StandardWrapperFacade
    implements ServletRegistration.Dynamic {
        public Dynamic(StandardWrapper wrapper) {
            super(wrapper);
        }
    }
}

