/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.SmapUtil;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.jboss.web.JasperLogger;

public class JDTCompiler
extends Compiler {
    @Override
    protected void generateClass(String[] smap) throws FileNotFoundException, JasperException, Exception {
        String opt;
        long t1 = 0L;
        if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        final String sourceFile = this.ctxt.getServletJavaFileName();
        final String outputDir = this.ctxt.getOptions().getScratchDir().getAbsolutePath();
        String packageName = this.ctxt.getServletPackageName();
        final String targetClassName = (packageName.length() != 0 ? packageName + "." : "") + this.ctxt.getServletClassName();
        final ClassLoader classLoader = this.ctxt.getJspLoader();
        String[] fileNames = new String[]{sourceFile};
        String[] classNames = new String[]{targetClassName};
        final ArrayList problemList = new ArrayList();
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result = result + sep;
                    result = result + new String(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result);
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result = result + sep;
                    result = result + new String(packageName[i]);
                    sep = ".";
                }
                result = result + sep;
                result = result + new String(typeName);
                return this.findType(result);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NameEnvironmentAnswer findType(String className) {
                block23: {
                    NameEnvironmentAnswer nameEnvironmentAnswer;
                    InputStream is = null;
                    try {
                        int count;
                        if (className.equals(targetClassName)) {
                            class CompilationUnit
                            implements ICompilationUnit {
                                String className;
                                String sourceFile;

                                CompilationUnit(String sourceFile, String className) {
                                    this.className = className;
                                    this.sourceFile = sourceFile;
                                }

                                public char[] getFileName() {
                                    return this.sourceFile.toCharArray();
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public char[] getContents() {
                                    char[] result = null;
                                    FileInputStream is = null;
                                    Reader reader = null;
                                    try {
                                        is = new FileInputStream(this.sourceFile);
                                        reader = new BufferedReader(new InputStreamReader((InputStream)is, JDTCompiler.this.ctxt.getOptions().getJavaEncoding()));
                                        if (reader != null) {
                                            int count;
                                            char[] chars = new char[8192];
                                            StringBuilder buf = new StringBuilder();
                                            while ((count = reader.read(chars, 0, chars.length)) > 0) {
                                                buf.append(chars, 0, count);
                                            }
                                            result = new char[buf.length()];
                                            buf.getChars(0, result.length, result, 0);
                                        }
                                    }
                                    catch (IOException e) {
                                        JasperLogger.COMPILER_LOGGER.errorReadingSourceFile(this.sourceFile, e);
                                    }
                                    finally {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (IOException exc) {}
                                        }
                                        if (is != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException exc) {}
                                        }
                                    }
                                    return result;
                                }

                                public char[] getMainTypeName() {
                                    int dot = this.className.lastIndexOf(46);
                                    if (dot > 0) {
                                        return this.className.substring(dot + 1).toCharArray();
                                    }
                                    return this.className.toCharArray();
                                }

                                public char[][] getPackageName() {
                                    StringTokenizer izer = new StringTokenizer(this.className, ".");
                                    char[][] result = new char[izer.countTokens() - 1][];
                                    for (int i = 0; i < result.length; ++i) {
                                        String tok = izer.nextToken();
                                        result[i] = tok.toCharArray();
                                    }
                                    return result;
                                }

                                public boolean ignoreOptionalProblems() {
                                    return false;
                                }
                            }
                            CompilationUnit compilationUnit = new CompilationUnit(sourceFile, className);
                            NameEnvironmentAnswer nameEnvironmentAnswer2 = new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                            return nameEnvironmentAnswer2;
                        }
                        String resourceName = className.replace('.', '/') + ".class";
                        is = classLoader.getResourceAsStream(resourceName);
                        if (is == null) break block23;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            baos.write(buf, 0, count);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    }
                    catch (IOException exc) {
                        JasperLogger.COMPILER_LOGGER.errorReadingClassFile(className, exc);
                        break block23;
                    }
                    catch (ClassFormatException exc) {
                        JasperLogger.COMPILER_LOGGER.errorReadingClassFile(className, exc);
                        break block23;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException exc) {}
                        }
                    }
                    return nameEnvironmentAnswer;
                }
                return null;
            }

            private boolean isPackage(String result) {
                if (result.equals(targetClassName)) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                InputStream is = classLoader.getResourceAsStream(resourceName);
                return is == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String str;
                String result = "";
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result = result + sep;
                        String str2 = new String(parentPackageName[i]);
                        result = result + str2;
                        sep = ".";
                    }
                }
                if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                    return false;
                }
                result = result + sep;
                result = result + str;
                return this.isPackage(result);
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        if (this.ctxt.getOptions().getJavaEncoding() != null) {
            settings.put("org.eclipse.jdt.core.encoding", this.ctxt.getOptions().getJavaEncoding());
        }
        if (this.ctxt.getOptions().getClassDebugInfo()) {
            settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        if (this.ctxt.getOptions().getCompilerSourceVM() != null) {
            opt = this.ctxt.getOptions().getCompilerSourceVM();
            if (opt.equals("1.1")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.1");
            } else if (opt.equals("1.2")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.2");
            } else if (opt.equals("1.3")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.3");
            } else if (opt.equals("1.4")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
            } else if (opt.equals("1.5")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
            } else if (opt.equals("1.6")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.6");
            } else if (opt.equals("1.7")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.7");
            } else {
                JasperLogger.COMPILER_LOGGER.unknownSourceJvm(opt);
                settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
            }
        } else {
            settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
        }
        if (this.ctxt.getOptions().getCompilerTargetVM() != null) {
            opt = this.ctxt.getOptions().getCompilerTargetVM();
            if (opt.equals("1.1")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            } else if (opt.equals("1.2")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            } else if (opt.equals("1.3")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
            } else if (opt.equals("1.4")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
            } else if (opt.equals("1.5")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            } else if (opt.equals("1.6")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            } else if (opt.equals("1.7")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
            } else {
                JasperLogger.COMPILER_LOGGER.unknownTargetJvm(opt);
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            }
        } else {
            settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            settings.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                try {
                    int i;
                    if (result.hasProblems()) {
                        CategorizedProblem[] problems = result.getProblems();
                        for (i = 0; i < problems.length; ++i) {
                            CategorizedProblem problem = problems[i];
                            if (!problem.isError()) continue;
                            String name = new String(problems[i].getOriginatingFileName());
                            try {
                                problemList.add(ErrorDispatcher.createJavacError(name, JDTCompiler.this.pageNodes, new StringBuilder(problem.getMessage()), problem.getSourceLineNumber(), JDTCompiler.this.ctxt));
                                continue;
                            }
                            catch (JasperException e) {
                                JasperLogger.COMPILER_LOGGER.errorCreatingCompilerReport((Throwable)((Object)e));
                            }
                        }
                    }
                    if (problemList.isEmpty()) {
                        ClassFile[] classFiles = result.getClassFiles();
                        for (i = 0; i < classFiles.length; ++i) {
                            ClassFile classFile = classFiles[i];
                            char[][] compoundName = classFile.getCompoundName();
                            String className = "";
                            String sep = "";
                            for (int j = 0; j < compoundName.length; ++j) {
                                className = className + sep;
                                className = className + new String(compoundName[j]);
                                sep = ".";
                            }
                            byte[] bytes = classFile.getBytes();
                            String outFile = outputDir + "/" + className.replace('.', '/') + ".class";
                            FileOutputStream fout = new FileOutputStream(outFile);
                            BufferedOutputStream bos = new BufferedOutputStream(fout);
                            bos.write(bytes);
                            bos.close();
                        }
                    }
                }
                catch (IOException exc) {
                    JasperLogger.COMPILER_LOGGER.errorCompiling(exc);
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[classNames.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            String className = classNames[i];
            compilationUnits[i] = new CompilationUnit(fileNames[i], className);
        }
        org.eclipse.jdt.internal.compiler.Compiler compiler = new org.eclipse.jdt.internal.compiler.Compiler(env, policy, settings, requestor, (IProblemFactory)problemFactory, true);
        compiler.compile(compilationUnits);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(this.ctxt.getServletJavaFileName());
            javaFile.delete();
        }
        if (!problemList.isEmpty()) {
            JavacErrorDetail[] jeds = problemList.toArray(new JavacErrorDetail[0]);
            this.errDispatcher.javacError(jeds);
        }
        if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            JasperLogger.COMPILER_LOGGER.debug("Compiled " + this.ctxt.getServletJavaFileName() + " " + (t2 - t1) + "ms");
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smap);
        }
    }
}

