/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.cometd.bayeux.Channel;
import org.apache.cometd.bayeux.Client;
import org.apache.cometd.bayeux.DataFilter;
import org.apache.cometd.bayeux.Message;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.MessageImpl;
import org.jboss.web.CoyoteMessages;

public class ChannelImpl
implements Channel {
    protected String id = null;
    protected LinkedList<Client> subscribers = new LinkedList();
    protected LinkedList<DataFilter> filters = new LinkedList();
    protected boolean persistent = true;

    protected ChannelImpl(String id) {
        assert (id != null);
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean matches(String pattern) {
        if (pattern == null) {
            throw CoyoteMessages.MESSAGES.invalidNullChannelPattern();
        }
        if (this.getId().equals(pattern)) {
            return true;
        }
        int wildcardPos = pattern.indexOf("/*");
        if (wildcardPos == -1) {
            return false;
        }
        boolean multiSegment = pattern.indexOf("**") != -1;
        String leadSubstring = pattern.substring(0, wildcardPos);
        if (leadSubstring == null) {
            return false;
        }
        if (multiSegment) {
            return this.getId().startsWith(leadSubstring);
        }
        if (this.getId().length() <= wildcardPos + 2) {
            return false;
        }
        return !this.getId().substring(wildcardPos + 2).contains("/");
    }

    @Override
    public List<Client> getSubscribers() {
        return Collections.unmodifiableList(this.subscribers);
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void publish(Message msg) {
        this.publish(new Message[]{msg});
    }

    @Override
    public void publish(Message[] msgs) {
        if (msgs == null) {
            return;
        }
        Message[] imsgs = new MessageImpl[msgs.length];
        for (int i = 0; msgs != null && i < msgs.length; ++i) {
            Message message = msgs[i];
            if (!(message instanceof MessageImpl)) {
                throw CoyoteMessages.MESSAGES.invalidMessagePublish();
            }
            MessageImpl msg = (MessageImpl)((MessageImpl)message).clone();
            msg.setChannel(this);
            Iterator it = this.filters.iterator();
            while (it.hasNext()) {
                ((DataFilter)it.next()).filter(msg);
            }
            imsgs[i] = msg;
        }
        for (ClientImpl clientImpl : this.subscribers) {
            clientImpl.deliverInternal(this, imsgs);
        }
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public void subscribe(Client subscriber) {
        if (!this.subscribers.contains(subscriber)) {
            this.subscribers.addLast(subscriber);
            ((ClientImpl)subscriber).subscribed(this);
        }
    }

    @Override
    public Client unsubscribe(Client subscriber) {
        if (this.subscribers.remove(subscriber)) {
            ((ClientImpl)subscriber).unsubscribed(this);
            return subscriber;
        }
        return null;
    }

    @Override
    public void addFilter(DataFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.addLast(filter);
        }
    }

    @Override
    public DataFilter removeFilter(DataFilter filter) {
        if (this.filters.remove(filter)) {
            return filter;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append("; channelId=").append(this.getId());
        return buf.toString();
    }
}

