/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.xa;

import java.util.Collections;
import java.util.List;
import org.jboss.jca.adapters.jdbc.spi.URLXASelectorStrategy;
import org.jboss.jca.adapters.jdbc.spi.XAData;

public class URLXASelector
implements URLXASelectorStrategy {
    private List<XAData> data;
    private XAData current;
    private int currentIndex;

    @Override
    public void init(List<XAData> data) {
        if (data == null || data.size() == 0) {
            throw new IllegalArgumentException("Data is empty");
        }
        this.data = Collections.unmodifiableList(data);
        this.reset();
    }

    @Override
    public boolean hasMore() {
        return this.currentIndex < this.data.size() - 1;
    }

    @Override
    public XAData active() {
        if (this.current != null) {
            return this.current;
        }
        ++this.currentIndex;
        if (this.currentIndex == this.data.size()) {
            this.currentIndex = 0;
        }
        this.current = this.data.get(this.currentIndex);
        return this.current;
    }

    @Override
    public void fail(XAData xd) {
        if (this.current != null && this.current.equals(xd)) {
            this.current = null;
        }
    }

    @Override
    public void reset() {
        this.current = null;
        this.currentIndex = -1;
    }

    @Override
    public String getData() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.data.size(); ++i) {
            XAData xd = this.data.get(i);
            sb.append(xd.getUrl());
            if (i >= this.data.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("URLXASelector@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[data=").append(this.data);
        sb.append(" current=").append(this.current);
        sb.append(" currentIndex=").append(this.currentIndex);
        sb.append("]");
        return sb.toString();
    }
}

