/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;

public class HazelCastTokenStore
implements TokenStore {
    public static final long DEFAULT_TTL = 3600L;
    public static final long MAX_TTL = 43200L;
    private IMap<Object, Object> cacheMap;
    private long ttl = 3600L;

    public HazelCastTokenStore(String mapName) {
        this.cacheMap = Hazelcast.getDefaultInstance().getMap(mapName);
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void add(SecurityToken token) {
        int parsedTTL;
        if (token != null && !StringUtils.isEmpty((String)token.getId()) && (parsedTTL = this.getTTL(token)) > 0) {
            this.cacheMap.put((Object)token.getId(), (Object)token, (long)parsedTTL, TimeUnit.SECONDS);
        }
    }

    public void add(String identifier, SecurityToken token) {
        int parsedTTL;
        if (token != null && !StringUtils.isEmpty((String)identifier) && (parsedTTL = this.getTTL(token)) > 0) {
            this.cacheMap.put((Object)identifier, (Object)token, (long)parsedTTL, TimeUnit.SECONDS);
        }
    }

    public void remove(String identifier) {
        if (!StringUtils.isEmpty((String)identifier) && this.cacheMap.containsKey((Object)identifier)) {
            this.cacheMap.remove((Object)identifier);
        }
    }

    public Collection<String> getTokenIdentifiers() {
        return CastUtils.cast((Collection)this.cacheMap.keySet());
    }

    public Collection<SecurityToken> getExpiredTokens() {
        return null;
    }

    public SecurityToken getToken(String identifier) {
        return (SecurityToken)this.cacheMap.get((Object)identifier);
    }

    private int getTTL(SecurityToken token) {
        int parsedTTL = 0;
        if (token.getExpires() != null) {
            Date expires = token.getExpires();
            Date current = new Date();
            long expiryTime = (expires.getTime() - current.getTime()) / 1000L;
            if (expiryTime < 0L) {
                return 0;
            }
            parsedTTL = (int)expiryTime;
            if ((expiryTime != (long)parsedTTL || (long)parsedTTL > 43200L) && this.ttl != (long)(parsedTTL = (int)this.ttl)) {
                parsedTTL = 3600;
            }
        } else {
            parsedTTL = (int)this.ttl;
            if (this.ttl != (long)parsedTTL) {
                parsedTTL = 3600;
            }
        }
        return parsedTTL;
    }
}

