/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.io.Closeable;
import java.io.IOException;
import java.util.jar.Manifest;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.MountExplodedMarker;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WebApplicationBundleUtils;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class RemountDeploymentRootProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        MountHandle mountHandle;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Manifest manifest = (Manifest)depUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (manifest == null || MountExplodedMarker.isMountExploded((DeploymentUnit)depUnit)) {
            return;
        }
        if (!WebApplicationBundleUtils.isWebApplicationBundle((DeploymentUnit)depUnit)) {
            return;
        }
        ResourceRoot resourceRoot = (ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        Object handle = resourceRoot.getMountHandle();
        VFSUtils.safeClose((Closeable)handle);
        VirtualFile deploymentContents = (VirtualFile)depUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS);
        DeploymentMountProvider deploymentMountProvider = (DeploymentMountProvider)depUnit.getAttachment(Attachments.SERVER_DEPLOYMENT_REPOSITORY);
        VirtualFile deploymentRoot = VFS.getChild((String)("content/" + depUnit.getName()));
        try {
            handle = deploymentMountProvider.mountDeploymentContent(deploymentContents, deploymentRoot, MountType.EXPANDED);
            mountHandle = new MountHandle((Closeable)handle);
        }
        catch (IOException e) {
            VFSUtils.safeClose((Closeable)handle);
            throw ServerMessages.MESSAGES.deploymentMountFailed(e);
        }
        resourceRoot = new ResourceRoot(deploymentRoot, mountHandle);
        resourceRoot.putAttachment(Attachments.MANIFEST, (Object)manifest);
        ModuleRootMarker.mark((ResourceRoot)resourceRoot);
        depUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, (Object)resourceRoot);
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

