/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.BundleLifecycleIntegration;
import org.jboss.as.osgi.web.WebBundleURIParser;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;

public class WebBundleStructureProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
        if (metadata != null) {
            return;
        }
        Deployment dep = BundleLifecycleIntegration.getDeployment((String)depUnit.getName());
        if (dep != null) {
            return;
        }
        Manifest manifest = WebBundleURIParser.parse(depUnit.getName());
        if (manifest != null) {
            metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
            depUnit.putAttachment(OSGiConstants.OSGI_METADATA_KEY, (Object)metadata);
            depUnit.putAttachment(Attachments.OSGI_MANIFEST, (Object)manifest);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

