/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.commons.ssl;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import org.picketbox.commons.cipher.Base64;

public class ExportPrivateKey {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Export the private key of a certificate\nUsage: ExportPrivateKey <keystore> <alias> [password]\nkeystore: location of the keystore\nalias: alias under which the certificate is stored\npassword: password of the keystore. If this argument is not provided it will be prompted");
            System.exit(1);
        }
        char[] pass = null;
        if (args.length == 3) {
            pass = args[2].toCharArray();
        } else {
            Console console = System.console();
            pass = console.readPassword("Enter the password: ", new Object[0]);
        }
        ExportPrivateKey myep = new ExportPrivateKey();
        myep.doit(args[0], args[1], pass);
    }

    public void doit(String fileName, String aliasName, char[] pass) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        File certificateFile = new File(fileName);
        ks.load(new FileInputStream(certificateFile), pass);
        KeyPair kp = this.getPrivateKey(ks, aliasName, pass);
        PrivateKey privKey = kp.getPrivate();
        String b64 = Base64.encodeBytes(privKey.getEncoded());
        System.out.println("Private key:");
        System.out.println("-----BEGIN PRIVATE KEY-----");
        System.out.println(b64);
        System.out.println("-----END PRIVATE KEY-----");
    }

    public KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        }
        catch (UnrecoverableKeyException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (KeyStoreException e) {
            // empty catch block
        }
        return null;
    }
}

