/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class VirtualJarInputStream
extends JarInputStream {
    private static final String MANIFEST_NAME = "MANIFEST.MF";
    private static final String META_INF_DIR = "META-INF";
    private final Deque<Iterator<VirtualFile>> entryItr = new ArrayDeque<Iterator<VirtualFile>>();
    private final VirtualFile root;
    private final Manifest manifest;
    private InputStream currentEntryStream = VFSUtils.emptyStream();
    private boolean closed;
    private static final VirtualFileFilter MANIFEST_FILTER = new VirtualFileFilter(){

        @Override
        public boolean accepts(VirtualFile file) {
            return !VirtualJarInputStream.MANIFEST_NAME.equalsIgnoreCase(file.getName());
        }
    };

    public VirtualJarInputStream(VirtualFile root) throws IOException {
        super(VFSUtils.emptyStream());
        this.root = root;
        VirtualFile manifest = root.getChild("META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            this.entryItr.add(Collections.singleton(manifest).iterator());
            this.manifest = VFSUtils.readManifest(manifest);
        } else {
            this.manifest = null;
        }
        this.entryItr.add(root.getChildren().iterator());
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        return this.getNextJarEntry();
    }

    @Override
    public JarEntry getNextJarEntry() throws IOException {
        this.closeEntry();
        Iterator<VirtualFile> topItr = this.entryItr.peekFirst();
        if (topItr == null) {
            return null;
        }
        if (!topItr.hasNext()) {
            this.entryItr.pop();
            return this.getNextJarEntry();
        }
        VirtualFile nextEntry = topItr.next();
        String entryName = this.getEntryName(nextEntry);
        if (nextEntry.isDirectory()) {
            List<VirtualFile> children = nextEntry.getChildren();
            if (entryName.equalsIgnoreCase(META_INF_DIR)) {
                children = nextEntry.getChildren(MANIFEST_FILTER);
            }
            this.entryItr.add(children.iterator());
            entryName = this.fixDirectoryName(entryName);
        }
        this.openCurrent(nextEntry);
        Attributes attributes = null;
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            attributes = manifest.getAttributes(entryName);
        }
        return new VirtualJarEntry(entryName, nextEntry, attributes);
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.checkForEoSAndReturn(this.currentEntryStream.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.checkForEoSAndReturn(this.currentEntryStream.read(b, off, len));
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.currentEntryStream.available() > 0 ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void closeEntry() throws IOException {
        if (this.currentEntryStream != null) {
            this.currentEntryStream.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.currentEntryStream.skip(n);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }

    private int checkForEoSAndReturn(int result) throws IOException {
        if (result == -1) {
            this.closeEntry();
            this.currentEntryStream = VFSUtils.emptyStream();
        }
        return result;
    }

    private void openCurrent(VirtualFile current) throws IOException {
        this.currentEntryStream = current.isDirectory() ? VFSUtils.emptyStream() : current.openStream();
    }

    private String getEntryName(VirtualFile entry) {
        return entry.getPathNameRelativeTo(this.root);
    }

    private String fixDirectoryName(String name) {
        if (!name.endsWith("/")) {
            return name + "/";
        }
        return name;
    }

    public static class VirtualJarEntry
    extends JarEntry {
        private final VirtualFile virtualFile;
        private final Attributes attributes;

        public VirtualJarEntry(String name, VirtualFile virtualFile, Attributes attributes) {
            super(name);
            this.virtualFile = virtualFile;
            this.attributes = attributes;
        }

        @Override
        public Attributes getAttributes() throws IOException {
            return this.attributes;
        }

        @Override
        public long getSize() {
            return this.virtualFile.getSize();
        }

        @Override
        public long getTime() {
            return this.virtualFile.getLastModified();
        }

        @Override
        public boolean isDirectory() {
            return this.virtualFile.isDirectory();
        }

        @Override
        public Certificate[] getCertificates() {
            CodeSigner[] signers = this.getCodeSigners();
            if (signers == null) {
                return null;
            }
            ArrayList<? extends Certificate> certs = new ArrayList<Certificate>();
            for (CodeSigner signer : signers) {
                certs.addAll(signer.getSignerCertPath().getCertificates());
            }
            return certs.toArray(new Certificate[certs.size()]);
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            return this.virtualFile.getCodeSigners();
        }
    }
}

