/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public final class NullStreamSinkConduit
implements StreamSinkConduit {
    private final XnioWorker worker;
    private final XnioIoThread writeThread;
    private WriteReadyHandler writeReadyHandler;
    private boolean shutdown;
    private boolean resumed;

    public NullStreamSinkConduit(XnioIoThread writeThread) {
        this.worker = writeThread.getWorker();
        this.writeThread = writeThread;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return Channels.drain(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        throughBuffer.limit(0);
        return Channels.drain(source, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        try {
            int n = src.remaining();
            return n;
        }
        finally {
            src.position(src.limit());
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long t = 0L;
        for (int i = 0; i < len; ++i) {
            t += (long)this.write(srcs[i + offs]);
        }
        return t;
    }

    @Override
    public boolean flush() throws IOException {
        return true;
    }

    @Override
    public boolean isWriteShutdown() {
        return this.shutdown;
    }

    @Override
    public void suspendWrites() {
        this.resumed = false;
    }

    @Override
    public void resumeWrites() {
        this.resumed = true;
        WriteReadyHandler handler = this.writeReadyHandler;
        this.writeThread.execute(new WriteReadyHandler.ReadyTask(handler));
    }

    @Override
    public void wakeupWrites() {
        this.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.resumed;
    }

    @Override
    public void awaitWritable() throws IOException {
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.writeThread;
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }

    @Override
    public void truncateWrites() throws IOException {
        this.terminateWrites();
    }

    @Override
    public void terminateWrites() throws IOException {
        if (!this.shutdown) {
            this.shutdown = true;
            this.writeReadyHandler.terminated();
        }
    }

    @Override
    public XnioWorker getWorker() {
        return this.worker;
    }
}

