/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.config.LoggingInitializer;
import org.jacorb.orb.ORB;
import org.jacorb.util.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacORBConfiguration
implements Configuration {
    private static final String CONFIG_LOG_VERBOSITY = "jacorb.config.log.verbosity";
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String EMPTY_STR = "";
    private static final String ATTR_LOG_VERBOSITY = "jacorb.log.default.verbosity";
    private static final String ATTR_LOG_FILE = "jacorb.logfile";
    private static final String ATTR_LOG_APPEND = "jacorb.logfile.append";
    private static final String ATTR_LOGGING_INITIALIZER = "jacorb.log.initializer";
    private static final int DEFAULT_LOG_LEVEL = 0;
    private Properties attributes;
    private String name;
    private final ORB orb;
    private Logger logger;

    public static Configuration getConfiguration(Properties props, ORB orb, boolean isApplet) throws ConfigurationException {
        String tmp;
        String orbID = "jacorb";
        String myOrbID = null;
        if (!isApplet) {
            try {
                myOrbID = System.getProperty("ORBid");
            }
            catch (SecurityException e) {
                isApplet = true;
                JacORBConfiguration.println("Could not access system property 'ORBid' - will use default...");
            }
        }
        if (props != null && (tmp = (String)props.get("ORBid")) != null) {
            myOrbID = tmp;
        }
        if (myOrbID != null) {
            if (myOrbID.equals("orb") || myOrbID.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + myOrbID + "> is reserved");
            }
            orbID = myOrbID;
        }
        return new JacORBConfiguration(orbID, props, orb, isApplet);
    }

    private JacORBConfiguration(String name, Properties orbProperties, ORB orb, boolean isApplet) throws ConfigurationException {
        this.name = name;
        this.orb = orb;
        this.attributes = new Properties();
        this.logger = this.getLogger("jacorb.config");
        if (isApplet) {
            this.initApplet(name, orbProperties);
        } else {
            this.init(name, orbProperties);
        }
        if (orb != null) {
            this.initLogging();
        }
    }

    private static void println(String mesg) {
        System.out.println(mesg);
    }

    private static void printErr(String mesg) {
        System.err.println(mesg);
    }

    private void init(String name, Properties orbProperties) throws ConfigurationException {
        List customPropFileNames;
        String configDir;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String separator = System.getProperty("file.separator");
        String home = System.getProperty("user.home");
        String lib = System.getProperty("java.home");
        boolean loaded = false;
        this.setAttributes(System.getProperties());
        String propFile = lib + separator + "lib" + separator + COMMON_PROPS;
        Properties commonProps = JacORBConfiguration.loadPropertiesFromFile(propFile);
        if (commonProps != null) {
            this.setAttributes(commonProps);
            loaded = true;
            this.logger.info("base configuration loaded from file " + propFile);
        }
        if ((commonProps = JacORBConfiguration.loadPropertiesFromFile(propFile = home + separator + COMMON_PROPS)) != null) {
            this.setAttributes(commonProps);
            loaded = true;
            this.logger.info("base configuration loaded from file " + propFile);
        }
        if ((commonProps = this.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            loaded = true;
            this.setAttributes(commonProps);
            this.logger.info("base configuration loaded from classpath orb.properties");
        }
        if ((configDir = this.getAttribute("jacorb.config.dir", EMPTY_STR)).length() == 0) {
            configDir = this.getAttribute("jacorb.home", EMPTY_STR);
        }
        if (configDir.length() != 0) {
            configDir = configDir + separator + "etc";
        } else {
            this.logger.warn("jacorb.home unset! Will use '.'");
            configDir = ".";
        }
        propFile = configDir + separator + name + fileSuffix;
        Properties orbConfig = JacORBConfiguration.loadPropertiesFromFile(propFile);
        if (orbConfig != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            this.logger.info("configuration " + name + " loaded from file " + propFile);
        } else {
            this.logger.warn("File " + propFile + " for configuration " + name + " not found");
        }
        orbConfig = this.loadPropertiesFromClassPath(name + fileSuffix);
        if (orbConfig != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            this.logger.info("configuration " + name + " loaded from classpath");
        }
        if (!(customPropFileNames = this.getAttributeList("custom.props")).isEmpty()) {
            for (String fileName : customPropFileNames) {
                Properties customProps = JacORBConfiguration.loadPropertiesFromFile(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    this.logger.info("custom properties loaded from file " + fileName);
                    continue;
                }
                this.logger.warn("custom properties not found in " + fileName);
            }
        }
        this.setAttributes(System.getProperties());
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if (!loaded) {
            this.logger.warn("no properties found for configuration " + name);
        }
    }

    private void initApplet(String name, Properties orbProperties) throws ConfigurationException {
        String propFile;
        Properties orbConfig;
        Properties commonProps;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        boolean loaded = false;
        if (orbProperties != null) {
            this.setAttributes(orbProperties);
        }
        if ((commonProps = this.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            this.setAttributes(commonProps);
            loaded = true;
            this.logger.info("base configuration loaded from classpath orb.properties");
        }
        if ((orbConfig = this.loadPropertiesFromClassPath(propFile = name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            this.logger.info("configuration " + name + " loaded from classpath " + propFile);
        } else {
            this.logger.warn("File " + propFile + " for configuration " + name + " not found in classpath");
        }
        List customPropFileNames = this.getAttributeList("custom.props");
        if (!customPropFileNames.isEmpty()) {
            for (String fileName : customPropFileNames) {
                Properties customProps = this.loadPropertiesFromClassPath(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    this.logger.info("custom properties loaded from classpath " + fileName);
                    continue;
                }
                this.logger.warn("custom properties " + fileName + " not found in classpath");
            }
        }
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if (!loaded) {
            this.logger.warn("no properties found for configuration " + name);
        }
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    void setAttributes(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key;
            String value;
            Object obj = e.nextElement();
            if (!(obj instanceof String) || !((value = properties.getProperty(key = (String)obj)) instanceof String) && value != null) continue;
            this.setAttribute(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String fileName) {
        Properties properties;
        FileInputStream stream = new FileInputStream(fileName);
        try {
            Properties result = new Properties();
            result.load(stream);
            properties = result;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                JacORBConfiguration.println("could not read config file: " + fileName);
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromClassPath(String name) {
        Properties result;
        block6: {
            result = null;
            try {
                ClassLoader clazzLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : JacORBConfiguration.class.getClassLoader();
                URL url = clazzLoader.getResource(name);
                if (url == null) break block6;
                result = new Properties();
                InputStream stream = url.openStream();
                try {
                    result.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ioe) {
                this.logger.error("could not read config file: " + name, (Throwable)ioe);
            }
        }
        return result;
    }

    private void initLogging() {
        LoggingInitializer li = (LoggingInitializer)this.getAttributeAsObject(ATTR_LOGGING_INITIALIZER, "org.jacorb.config.JdkLoggingInitializer");
        li.init(this);
    }

    public ORB getORB() {
        return this.orb;
    }

    public Logger getLogger(String name) {
        String implName;
        String loggerName = name;
        if (this.getAttributeAsBoolean("jacorb.log.split_on_implname", false) && (implName = this.getAttribute("jacorb.implname", null)) != null && implName.length() > 0) {
            if (name.equals("jacorb")) {
                loggerName = "jacorb." + implName;
            } else if (name.startsWith("jacorb.")) {
                loggerName = "jacorb." + implName + "." + name.substring(7);
            }
        }
        return LoggerFactory.getLogger((String)loggerName);
    }

    public String getLoggerName(Class clz) {
        String clazzName = clz.getName();
        String packageName = clazzName.substring(0, clazzName.lastIndexOf(46));
        if (packageName != null && packageName.startsWith("org.jacorb")) {
            return packageName.substring(4);
        }
        return packageName;
    }

    public String getAttribute(String key) {
        String result = this.attributes.getProperty(key);
        if (result != null) {
            return result;
        }
        throw new ConfigurationException("attribute " + key + " is not defined");
    }

    public String getAttribute(String key, String defaultValue) {
        return this.attributes.getProperty(key, defaultValue);
    }

    public int getAttributeAsInteger(String key, int defaultValue) {
        String value = this.attributes.getProperty(key, null);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            if (value.trim().length() < 1) {
                return defaultValue;
            }
            try {
                int i = Integer.parseInt(value.trim());
                return i;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        throw new ConfigurationException("value for attribute " + key + " is not numeric: " + value);
    }

    public int getAttributeAsInteger(String key) {
        String value = this.attributes.getProperty(key, null);
        if (value == null) {
            throw new ConfigurationException("value for attribute " + key + " is not set");
        }
        return this.getAttributeAsInteger(key, 0);
    }

    public long getAttributeAsLong(String key, long defaultValue) {
        String value = this.attributes.getProperty(key, null);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                long i = Long.parseLong(value.trim());
                return i;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        throw new ConfigurationException("value for attribute " + key + " is not numeric: " + value);
    }

    public List getAttributeList(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String value = null;
        try {
            value = this.getAttribute(key);
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().trim());
            }
        }
        return result;
    }

    public Object getAttributeAsObject(String key) throws ConfigurationException {
        String className = this.getAttribute(key, null);
        if (className != null && className.length() > 0) {
            return this.newInstance(key, className);
        }
        return null;
    }

    private Object newInstance(String key, String className) throws ConfigurationException {
        try {
            Class clazz = ObjectUtil.classForName(className);
            Object instance = clazz.newInstance();
            if (instance instanceof Configurable) {
                ((Configurable)instance).configure(this);
            }
            return instance;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build class from key >" + key + "<: " + e);
        }
    }

    public Object getAttributeAsObject(String key, String defaultClass) throws ConfigurationException {
        Object result = this.getAttributeAsObject(key);
        if (result == null) {
            return this.newInstance("default", defaultClass);
        }
        return result;
    }

    public boolean getAttributeAsBoolean(String key) throws ConfigurationException {
        String value = this.getAttribute(key);
        if (value != null && value.length() > 0) {
            return ON.equals(value = value.trim().toLowerCase()) || TRUE.equals(value);
        }
        return false;
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        String value = this.getAttribute(key, EMPTY_STR);
        if (value.length() > 0) {
            return ON.equals(value = value.trim().toLowerCase()) || TRUE.equals(value);
        }
        return defaultValue;
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public List getAttributeNamesWithPrefix(String prefix) {
        ArrayList<String> attributesWithPrefix = new ArrayList<String>();
        String[] allAttributes = this.getAttributeNames();
        for (int x = 0; x < allAttributes.length; ++x) {
            if (!allAttributes[x].startsWith(prefix)) continue;
            attributesWithPrefix.add(allAttributes[x]);
        }
        return Collections.unmodifiableList(attributesWithPrefix);
    }
}

