/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import org.jacorb.ir.gui.typesystem.remote.IRNodeWithType;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.TypeCode;

public class IRParameter
extends IRNodeWithType {
    private ParameterDescription parDesc;

    protected IRParameter() {
    }

    protected IRParameter(ParameterDescription parDesc) {
        this.setName(parDesc.name);
        this.setAssociatedTypeSystemNode(RemoteTypeSystem.createTypeSystemNode(parDesc.type_def));
        this.parDesc = parDesc;
    }

    public ParameterMode getMode() {
        return this.parDesc.mode;
    }

    public TypeCode getTypeCode() {
        return this.parDesc.type;
    }

    public String getInstanceNodeTypeName() {
        String result = super.getInstanceNodeTypeName();
        String suffix = null;
        switch (this.parDesc.mode.value()) {
            case 0: {
                suffix = "in";
                break;
            }
            case 1: {
                suffix = "out";
                break;
            }
            case 2: {
                suffix = "inout";
                break;
            }
        }
        if (suffix != null) {
            result = suffix + " " + result;
        }
        return result;
    }

    public static String nodeTypeName() {
        return "";
    }
}

