/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Hashtable;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;

public abstract class RequestInfoImpl
extends LocalObject
implements RequestInfo {
    protected int request_id;
    protected String operation;
    protected Parameter[] arguments = null;
    protected TypeCode[] exceptions = null;
    protected Any result = null;
    protected boolean response_expected;
    protected Object forward_reference = null;
    protected short reply_status;
    protected Current current = null;
    protected final Hashtable request_ctx;
    protected final Hashtable reply_ctx;
    protected short caller_op = (short)-1;

    public RequestInfoImpl() {
        this.request_ctx = new Hashtable();
        this.reply_ctx = new Hashtable();
    }

    public void setRequestServiceContexts(ServiceContext[] ctx) {
        for (int _i = 0; _i < ctx.length; ++_i) {
            this.request_ctx.put(ObjectUtil.newInteger(ctx[_i].context_id), ctx[_i]);
        }
    }

    public void setReplyServiceContexts(ServiceContext[] ctx) {
        for (int _i = 0; _i < ctx.length; ++_i) {
            this.reply_ctx.put(ObjectUtil.newInteger(ctx[_i].context_id), ctx[_i]);
        }
    }

    public void setArguments(Parameter[] args) {
        this.arguments = args;
    }

    public void setResult(Any result) {
        this.result = result;
    }

    public Current current() {
        return this.current;
    }

    public void setCurrent(Current current) {
        this.current = current;
    }

    public void setReplyStatus(short reply_status) {
        this.reply_status = reply_status;
    }

    public void setForwardReference(Object forward_reference) {
        this.forward_reference = forward_reference;
    }

    public Parameter[] arguments() {
        return this.arguments;
    }

    public String[] contexts() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    public TypeCode[] exceptions() {
        return this.exceptions;
    }

    public Object forward_reference() {
        return this.forward_reference;
    }

    public ServiceContext get_reply_service_context(int id) {
        Integer _id = ObjectUtil.newInteger(id);
        if (!this.reply_ctx.containsKey(_id)) {
            throw new BAD_PARAM("No ServiceContext with id " + id, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return (ServiceContext)this.reply_ctx.get(_id);
    }

    public ServiceContext get_request_service_context(int id) {
        Integer _id = ObjectUtil.newInteger(id);
        if (!this.request_ctx.containsKey(_id)) {
            throw new BAD_PARAM("No ServiceContext with id " + id, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return (ServiceContext)this.request_ctx.get(_id);
    }

    public Any get_slot(int id) throws InvalidSlot {
        return this.current.get_slot(id);
    }

    public String operation() {
        return this.operation;
    }

    public String[] operation_context() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    public short reply_status() {
        return this.reply_status;
    }

    public int request_id() {
        return this.request_id;
    }

    public boolean response_expected() {
        return this.response_expected;
    }

    public Any result() {
        if (this.result == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.result;
    }

    public short sync_scope() {
        return 1;
    }
}

