/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.GroupSequence;
import javax.validation.Valid;
import org.hibernate.validator.group.GroupSequenceProvider;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedMethod;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public class AnnotationMetaDataProvider
implements MetaDataProvider {
    private static final Log log = LoggerFactory.make();
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final ConstraintHelper constraintHelper;
    private final ConcurrentReferenceHashMap<Class<?>, BeanConfiguration<?>> configuredBeans;
    private final AnnotationProcessingOptions annotationProcessingOptions;

    public AnnotationMetaDataProvider(ConstraintHelper constraintHelper, AnnotationProcessingOptions annotationProcessingOptions) {
        this.constraintHelper = constraintHelper;
        this.annotationProcessingOptions = annotationProcessingOptions;
        this.configuredBeans = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    }

    @Override
    public AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return new AnnotationProcessingOptions();
    }

    @Override
    public <T> List<BeanConfiguration<? super T>> getBeanConfigurationForHierarchy(Class<T> beanClass) {
        ArrayList<BeanConfiguration<T>> configurations = CollectionHelper.newArrayList();
        for (Class<?> hierarchyClass : ReflectionHelper.computeClassHierarchy(beanClass, true)) {
            BeanConfiguration<?> configuration = this.getBeanConfiguration(hierarchyClass);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    private BeanConfiguration<?> getBeanConfiguration(Class<?> beanClass) {
        BeanConfiguration<?> configuration = this.configuredBeans.get(beanClass);
        if (configuration != null) {
            return configuration;
        }
        configuration = this.retrieveBeanConfiguration(beanClass);
        this.configuredBeans.put(beanClass, configuration);
        return configuration;
    }

    private <T> BeanConfiguration<T> retrieveBeanConfiguration(Class<T> beanClass) {
        Set<ConstrainedElement> propertyMetaData = this.getPropertyMetaData(beanClass);
        propertyMetaData.addAll(this.getMethodMetaData(beanClass));
        Set<MetaConstraint<?>> classLevelConstraints = this.getClassLevelConstraints(beanClass);
        if (!classLevelConstraints.isEmpty()) {
            ConstrainedType classLevelMetaData = new ConstrainedType(ConfigurationSource.ANNOTATION, new BeanConstraintLocation(beanClass), classLevelConstraints);
            propertyMetaData.add(classLevelMetaData);
        }
        return new BeanConfiguration<T>(ConfigurationSource.ANNOTATION, beanClass, propertyMetaData, this.getDefaultGroupSequence(beanClass), this.getDefaultGroupSequenceProvider(beanClass));
    }

    private List<Class<?>> getDefaultGroupSequence(Class<?> beanClass) {
        GroupSequence groupSequenceAnnotation = beanClass.getAnnotation(GroupSequence.class);
        return groupSequenceAnnotation != null ? Arrays.asList(groupSequenceAnnotation.value()) : null;
    }

    private <T> DefaultGroupSequenceProvider<? super T> getDefaultGroupSequenceProvider(Class<T> beanClass) {
        GroupSequenceProvider groupSequenceProviderAnnotation = beanClass.getAnnotation(GroupSequenceProvider.class);
        if (groupSequenceProviderAnnotation != null) {
            return this.newGroupSequenceProviderClassInstance(beanClass, groupSequenceProviderAnnotation.value());
        }
        return null;
    }

    private <T> DefaultGroupSequenceProvider<? super T> newGroupSequenceProviderClassInstance(Class<T> beanClass, Class<?> providerClass) {
        Method[] providerMethods;
        for (Method method : providerMethods = ReflectionHelper.getMethods(providerClass)) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!"getValidationGroups".equals(method.getName()) || method.isBridge() || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(beanClass)) continue;
            return (DefaultGroupSequenceProvider)ReflectionHelper.newInstance(providerClass, "the default group sequence provider");
        }
        throw log.getWrongDefaultGroupSequenceProviderTypeException(beanClass.getName());
    }

    private Set<MetaConstraint<?>> getClassLevelConstraints(Class<?> clazz) {
        if (this.annotationProcessingOptions.areClassLevelConstraintAnnotationsIgnored(clazz)) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> classLevelConstraints = CollectionHelper.newHashSet();
        List<ConstraintDescriptorImpl<?>> classMetaData = this.findClassLevelConstraints(clazz);
        for (ConstraintDescriptorImpl<?> constraintDescription : classMetaData) {
            classLevelConstraints.add(this.createMetaConstraint(clazz, constraintDescription));
        }
        return classLevelConstraints;
    }

    private Set<ConstrainedElement> getPropertyMetaData(Class<?> beanClass) {
        HashSet<ConstrainedElement> propertyMetaData = CollectionHelper.newHashSet();
        for (Field field : ReflectionHelper.getDeclaredFields(beanClass)) {
            if (Modifier.isStatic(field.getModifiers()) || this.annotationProcessingOptions.arePropertyLevelConstraintAnnotationsIgnored(field) || field.isSynthetic()) continue;
            propertyMetaData.add(this.findPropertyMetaData(field));
        }
        return propertyMetaData;
    }

    private ConstrainedField findPropertyMetaData(Field field) {
        Set<MetaConstraint<?>> constraints = this.convertToMetaConstraints(this.findConstraints(field, ElementType.FIELD), field);
        boolean isCascading = field.isAnnotationPresent(Valid.class);
        return new ConstrainedField(ConfigurationSource.ANNOTATION, new BeanConstraintLocation(field), constraints, isCascading);
    }

    private Set<MetaConstraint<?>> convertToMetaConstraints(List<ConstraintDescriptorImpl<?>> constraintDescriptors, Field field) {
        HashSet<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        for (ConstraintDescriptorImpl<?> constraintDescription : constraintDescriptors) {
            constraints.add(this.createMetaConstraint(field, constraintDescription));
        }
        return constraints;
    }

    private Set<ConstrainedMethod> getMethodMetaData(Class<?> clazz) {
        Method[] declaredMethods;
        HashSet<ConstrainedMethod> methodMetaData = CollectionHelper.newHashSet();
        for (Method method : declaredMethods = ReflectionHelper.getDeclaredMethods(clazz)) {
            if (Modifier.isStatic(method.getModifiers()) || this.annotationProcessingOptions.arePropertyLevelConstraintAnnotationsIgnored(method) || method.isSynthetic()) continue;
            methodMetaData.add(this.findMethodMetaData(method));
        }
        return methodMetaData;
    }

    private ConstrainedMethod findMethodMetaData(Method method) {
        List<ConstrainedParameter> parameterConstraints = this.getParameterMetaData(method);
        boolean isCascading = method.isAnnotationPresent(Valid.class);
        Set<MetaConstraint<?>> constraints = this.convertToMetaConstraints(this.findConstraints(method, ElementType.METHOD), method);
        return new ConstrainedMethod(ConfigurationSource.ANNOTATION, new MethodConstraintLocation(method), parameterConstraints, constraints, isCascading);
    }

    private Set<MetaConstraint<?>> convertToMetaConstraints(List<ConstraintDescriptorImpl<?>> constraintsDescriptors, Method method) {
        HashSet<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        for (ConstraintDescriptorImpl<?> oneDescriptor : constraintsDescriptors) {
            constraints.add(this.createReturnValueMetaConstraint(method, oneDescriptor));
        }
        return constraints;
    }

    private List<ConstrainedParameter> getParameterMetaData(Method method) {
        ArrayList<ConstrainedParameter> metaData = CollectionHelper.newArrayList();
        int i = 0;
        for (Annotation[] annotationsOfOneParameter : method.getParameterAnnotations()) {
            boolean parameterIsCascading = false;
            String parameterName = "arg" + i;
            HashSet<MetaConstraint<?>> constraintsOfOneParameter = CollectionHelper.newHashSet();
            for (Annotation oneAnnotation : annotationsOfOneParameter) {
                List<ConstraintDescriptorImpl<?>> constraints = this.findConstraintAnnotations(oneAnnotation, ElementType.PARAMETER);
                for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : constraints) {
                    constraintsOfOneParameter.add(this.createParameterMetaConstraint(method, i, constraintDescriptorImpl));
                }
                if (!oneAnnotation.annotationType().equals(Valid.class)) continue;
                parameterIsCascading = true;
            }
            metaData.add(new ConstrainedParameter(ConfigurationSource.ANNOTATION, new MethodConstraintLocation(method, i), parameterName, constraintsOfOneParameter, parameterIsCascading));
            ++i;
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findConstraints(AccessibleObject member, ElementType type) {
        ArrayList metaData = new ArrayList();
        for (Annotation annotation : member.getDeclaredAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(annotation, type));
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList metaData = new ArrayList();
        for (Annotation annotation : beanClass.getDeclaredAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(annotation, ElementType.TYPE));
        }
        return metaData;
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl<?>> findConstraintAnnotations(A annotation, ElementType type) {
        ArrayList constraintDescriptors = new ArrayList();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (this.constraintHelper.isConstraintAnnotation(annotationType) || this.constraintHelper.isBuiltinConstraint(annotationType)) {
            constraints.add(annotation);
        } else if (this.constraintHelper.isMultiValueConstraint(annotationType)) {
            constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        }
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl<Annotation> constraintDescriptor = this.buildConstraintDescriptor(constraint, type);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> MetaConstraint<?> createMetaConstraint(Class<?> declaringClass, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, new BeanConstraintLocation(declaringClass));
    }

    private <A extends Annotation> MetaConstraint<?> createMetaConstraint(Member member, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, new BeanConstraintLocation(member));
    }

    private <A extends Annotation> MetaConstraint<A> createParameterMetaConstraint(Method method, int parameterIndex, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, new MethodConstraintLocation(method, parameterIndex));
    }

    private <A extends Annotation> MetaConstraint<A> createReturnValueMetaConstraint(Method method, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, new MethodConstraintLocation(method));
    }

    private <A extends Annotation> ConstraintDescriptorImpl<A> buildConstraintDescriptor(A annotation, ElementType type) {
        return new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, type, ConstraintOrigin.DEFINED_LOCALLY);
    }
}

