/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.security;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;

public class GetAccessibleCopyOfMember<T extends AccessibleObject>
implements PrivilegedAction<T> {
    private final T originalMember;

    public GetAccessibleCopyOfMember(T originalMember) {
        this.originalMember = originalMember;
    }

    @Override
    public T run() {
        T copy = this.copyMember();
        ((AccessibleObject)copy).setAccessible(true);
        return copy;
    }

    private T copyMember() {
        Class<?> declaringClass = ((Member)this.originalMember).getDeclaringClass();
        try {
            if (this.originalMember instanceof Field) {
                return (T)this.copyField((Field)this.originalMember, declaringClass);
            }
            if (this.originalMember instanceof Constructor) {
                return (T)this.copyConstructor((Constructor)this.originalMember, declaringClass);
            }
            if (this.originalMember instanceof Method) {
                return (T)this.copyMethod((Method)this.originalMember, declaringClass);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to obtain an accessible copy of " + this.originalMember, e);
        }
        throw new IllegalArgumentException("Unable to obtain an accessible copy of " + this.originalMember);
    }

    private Field copyField(Field field, Class<?> declaringClass) throws NoSuchFieldException {
        return declaringClass.getDeclaredField(field.getName());
    }

    private Method copyMethod(Method method, Class<?> declaringClass) throws NoSuchMethodException {
        return declaringClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
    }

    private Constructor<?> copyConstructor(Constructor<?> constructor, Class<?> declaringClass) throws NoSuchMethodException {
        return declaringClass.getDeclaredConstructor(constructor.getParameterTypes());
    }
}

