/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.util.List;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.weld.util.bytecode.DeferredBytecode;
import org.jboss.weld.util.bytecode.DescriptorUtils;

public class ConstructorUtils {
    private ConstructorUtils() {
    }

    public static void addDefaultConstructor(ClassFile file, List<DeferredBytecode> initialValueBytecode, boolean useUnsafeInstantiators) {
        ConstructorUtils.addConstructor("V", new String[0], new String[0], file, initialValueBytecode, useUnsafeInstantiators);
    }

    public static void addConstructor(String returnType, String[] params, String[] exceptions, ClassFile file, List<DeferredBytecode> initialValueBytecode, boolean useUnsafeInstantiators) {
        try {
            ClassMethod ctor = file.addMethod(1, "<init>", returnType, params);
            ctor.addCheckedExceptions(exceptions);
            CodeAttribute b = ctor.getCodeAttribute();
            for (DeferredBytecode iv : initialValueBytecode) {
                iv.apply(b);
            }
            b.aload(0);
            b.loadMethodParameters();
            b.invokespecial(file.getSuperclass(), "<init>", DescriptorUtils.getMethodDescriptor(params, returnType));
            if (!useUnsafeInstantiators) {
                b.aload(0);
                b.iconst(1);
                b.putfield(file.getName(), "constructed", "Z");
            }
            b.returnInstruction();
        }
        catch (DuplicateMemberException e) {
            throw new RuntimeException(e);
        }
    }
}

