/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.io.IoCallback;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.dmr.ModelNode;

public class Common {
    public static final ResponseCodeHandler MOVED_PERMANENTLY = new ResponseCodeHandler(301);
    public static final ResponseCodeHandler TEMPORARY_REDIRECT = new ResponseCodeHandler(307);
    public static final ResponseCodeHandler UNAUTHORIZED = new ResponseCodeHandler(403);
    public static final ResponseCodeHandler NOT_FOUND = ResponseCodeHandler.HANDLE_404;
    public static final ResponseCodeHandler METHOD_NOT_ALLOWED_HANDLER = new ResponseCodeHandler(405);
    public static final ResponseCodeHandler UNSUPPORTED_MEDIA_TYPE = new ResponseCodeHandler(415);
    public static final ResponseCodeHandler INTERNAL_SERVER_ERROR = new ResponseCodeHandler(500);
    public static final ResponseCodeHandler SERVICE_UNAVAIABLE = new ResponseCodeHandler(503);
    static final String APPLICATION_DMR_ENCODED = "application/dmr-encoded";
    static final String APPLICATION_JSON = "application/json";
    static final String TEXT_PLAIN = "text/plain";
    static final String TEXT_HTML = "text/html";
    static String UTF_8 = "utf-8";
    static final String GMT = "GMT";

    static void sendError(HttpServerExchange exchange, boolean isGet, boolean encode, String msg) {
        if (encode) {
            try {
                ModelNode response = new ModelNode();
                response.set(msg);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                response.writeBase64((OutputStream)bout);
                byte[] bytes = bout.toByteArray();
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/dmr-encoded;" + UTF_8);
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, String.valueOf(bytes.length));
                exchange.setResponseCode(500);
                exchange.getResponseSender().send(new String(bytes), IoCallback.END_EXCHANGE);
            }
            catch (IOException e) {
                Common.sendError(exchange, isGet, false, msg);
            }
        } else {
            byte[] bytes = msg.getBytes();
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain;" + UTF_8);
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, String.valueOf(bytes.length));
            exchange.setResponseCode(500);
            exchange.getResponseSender().send(msg, IoCallback.END_EXCHANGE);
        }
    }
}

