/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.domain.http.server.Common;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;
import org.xnio.streams.ChannelInputStream;

class DomainApiHandler
implements HttpHandler {
    private final ModelControllerClient modelController;

    DomainApiHandler(ModelControllerClient modelController) {
        this.modelController = modelController;
    }

    public void handleRequest(HttpServerExchange exchange) {
        ModelNode response;
        ModelNode dmr;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        boolean encode = "application/dmr-encoded".equals(requestHeaders.getFirst(Headers.ACCEPT)) || "application/dmr-encoded".equals(requestHeaders.getFirst(Headers.CONTENT_TYPE));
        boolean get = exchange.getRequestMethod().equals(Methods.GET);
        try {
            dmr = get ? this.convertGetRequest(exchange) : this.convertPostRequest(exchange, encode);
        }
        catch (Exception e) {
            HttpServerLogger.ROOT_LOGGER.debugf("Unable to construct ModelNode '%s'", e.getMessage());
            Common.sendError(exchange, get, false, e.getLocalizedMessage());
            return;
        }
        try {
            response = this.modelController.execute(new OperationBuilder(dmr).build());
        }
        catch (Throwable t) {
            HttpServerLogger.ROOT_LOGGER.modelRequestError(t);
            Common.sendError(exchange, get, encode, t.getLocalizedMessage());
            return;
        }
        if (response.hasDefined("outcome") && "failed".equals(response.get("outcome").asString())) {
            Common.sendError(exchange, get, encode, response.get("failure-description").asString());
            return;
        }
        boolean pretty = dmr.hasDefined("json.pretty") && dmr.get("json.pretty").asBoolean();
        DomainUtil.writeResponse(exchange, get, pretty, response, 200, encode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode convertPostRequest(HttpServerExchange exchange, boolean encode) throws IOException {
        ChannelInputStream in = new ChannelInputStream(exchange.getRequestChannel());
        try {
            ModelNode modelNode = encode ? ModelNode.fromBase64((InputStream)in) : ModelNode.fromJSONStream((InputStream)in);
            return modelNode;
        }
        finally {
            IoUtils.safeClose((Closeable)in);
        }
    }

    private ModelNode convertGetRequest(HttpServerExchange exchange) {
        ArrayList<String> pathSegments = this.decodePath(exchange.getRequestPath());
        Map queryParameters = exchange.getQueryParameters();
        GetOperation operation = null;
        ModelNode dmr = new ModelNode();
        for (Map.Entry entry : queryParameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)((Deque)entry.getValue()).getFirst();
            if ("operation".equals(key)) {
                try {
                    operation = GetOperation.valueOf(value.toUpperCase(Locale.ENGLISH).replace('-', '_'));
                    value = operation.realOperation();
                }
                catch (Exception e) {
                    throw HttpServerMessages.MESSAGES.invalidOperation(e, value);
                }
            }
            dmr.get((String)entry.getKey()).set(!value.equals("") ? value : "true");
        }
        if (operation == null) {
            operation = GetOperation.RESOURCE;
            dmr.get("operation").set(operation.realOperation);
        }
        ModelNode list = dmr.get("address").setEmptyList();
        for (int i = 1; i < pathSegments.size() - 1; i += 2) {
            list.add(pathSegments.get(i), pathSegments.get(i + 1));
        }
        return dmr;
    }

    private ArrayList<String> decodePath(String path) {
        int j;
        if (path == null) {
            throw new IllegalArgumentException();
        }
        int i = path.charAt(0) == '/' ? 1 : 0;
        ArrayList<String> segments = new ArrayList<String>();
        do {
            if ((j = path.indexOf(47, i)) == -1) {
                j = path.length();
            }
            segments.add(this.unescape(path.substring(i, j)));
        } while ((i = j + 1) < path.length());
        return segments;
    }

    private String unescape(String string) {
        try {
            return URLDecoder.decode(string, Common.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static enum GetOperation {
        RESOURCE("read-resource"),
        ATTRIBUTE("read-attribute"),
        RESOURCE_DESCRIPTION("read-resource-description"),
        SNAPSHOTS("list-snapshots"),
        OPERATION_DESCRIPTION("read-operation-description"),
        OPERATION_NAMES("read-operation-names");

        private String realOperation;

        private GetOperation(String realOperation) {
            this.realOperation = realOperation;
        }

        public String realOperation() {
            return this.realOperation;
        }
    }
}

