/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import org.jboss.as.domain.http.server.DomainUtil;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.security.RealmReadinessHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.dmr.ModelNode;

public class DmrFailureReadinessHandler
extends RealmReadinessHandler {
    private final String redirectTo;

    public DmrFailureReadinessHandler(SecurityRealm securityRealm, HttpHandler next, String redirectTo) {
        super(securityRealm, next);
        this.redirectTo = redirectTo;
    }

    @Override
    void rejectRequest(HttpServerExchange exchange) throws IOException {
        ModelNode rejection = new ModelNode();
        rejection.get("outcome").set("failed");
        rejection.get("failure-description").set(HttpServerMessages.MESSAGES.realmNotReadyMessage(DomainUtil.constructUrl(exchange, this.redirectTo)));
        rejection.get("rolled-back").set(Boolean.TRUE.toString());
        DomainUtil.writeResponse(exchange, false, true, rejection, 403, false);
    }
}

