/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.advertise.impl;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.jboss.modcluster.advertise.MulticastSocketFactory;

public class MulticastSocketFactoryImpl
implements MulticastSocketFactory {
    final Logger log = Logger.getLogger(this.getClass());
    private final boolean linuxlike;

    public MulticastSocketFactoryImpl() {
        String value = this.getSystemProperty("os.name");
        this.linuxlike = value != null && (value.toLowerCase().startsWith("linux") || value.toLowerCase().startsWith("mac") || value.toLowerCase().startsWith("hp"));
    }

    private String getSystemProperty(final String key) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(key);
                }
                catch (SecurityException e) {
                    MulticastSocketFactoryImpl.this.log.warn((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
        return AccessController.doPrivileged(action);
    }

    @Override
    public MulticastSocket createMulticastSocket(InetAddress address, int port) throws IOException {
        if (address == null || !this.linuxlike) {
            return new MulticastSocket(port);
        }
        if (!address.isMulticastAddress()) {
            this.log.warn((Object)(address + " is not a multicast address, will be ignored"));
            return new MulticastSocket(port);
        }
        try {
            return new MulticastSocket(new InetSocketAddress(address, port));
        }
        catch (IOException e) {
            StringBuilder builder = new StringBuilder();
            builder.append("could not bind to ").append(address.getHostAddress()).append(" (");
            builder.append(address instanceof Inet4Address ? "IPv4" : "IPv6").append(" address)");
            builder.append("; make sure your mcast_addr is of the same type as the IP stack (IPv4 or IPv6).");
            builder.append("\nWill ignore mcast_addr, but this may lead to cross talking ");
            builder.append("(see http://www.jboss.org/community/docs/DOC-9469 for details). ");
            this.log.warn((Object)builder.toString(), (Throwable)e);
            return new MulticastSocket(port);
        }
    }
}

