/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.DeploymentInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.clustering.web.DistributedCacheManagerFactory;
import org.jboss.as.clustering.web.DistributedCacheManagerFactoryService;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.SharedTldsMetaDataBuilder;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.common.WebComponentDescription;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.host.ContextActivator;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SecurityUtil;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.BufferCacheService;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;

public class UndertowDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String defaultServer;
    private final String defaultHost;
    private final String defaultContainer;

    public UndertowDeploymentProcessor(String defaultHost, String defaultContainer, String defaultServer) {
        this.defaultHost = defaultHost;
        if (defaultHost == null) {
            throw UndertowMessages.MESSAGES.nullDefaultHost();
        }
        this.defaultContainer = defaultContainer;
        this.defaultServer = defaultServer;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        String hostName = UndertowDeploymentProcessor.hostNameOfDeployment(warMetaData, this.defaultHost);
        this.processDeployment(warMetaData, deploymentUnit, phaseContext.getServiceTarget(), hostName);
    }

    static String hostNameOfDeployment(WarMetaData metaData, String defaultHost) {
        String hostName;
        Collection<Object> hostNames = null;
        if (metaData.getMergedJBossWebMetaData() != null) {
            hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        }
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(defaultHost);
        }
        if ((hostName = (String)hostNames.iterator().next()) == null) {
            throw UndertowMessages.MESSAGES.nullHostName();
        }
        return hostName;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processDeployment(WarMetaData warMetaData, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, String hostName) throws DeploymentUnitProcessingException {
        DistributedCacheManagerFactoryService factoryService;
        DistributedCacheManagerFactory factory;
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException((Throwable)UndertowMessages.MESSAGES.failedToResolveModule(deploymentUnit));
        }
        DeploymentClassIndex deploymentClassIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        List setupActions = deploymentUnit.getAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS);
        metaData.resolveRunAs();
        ScisMetaData scisMetaData = (ScisMetaData)deploymentUnit.getAttachment(ScisMetaData.ATTACHMENT_KEY);
        HashSet<ServiceName> dependentComponents = new HashSet<ServiceName>();
        List components = deploymentUnit.getAttachmentList(WebComponentDescription.WEB_COMPONENTS);
        Set failed = (Set)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.FAILED_COMPONENTS);
        for (ServiceName component : components) {
            if (failed.contains(component)) continue;
            dependentComponents.add(component);
        }
        ComponentRegistry componentRegistry = (ComponentRegistry)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.COMPONENT_REGISTRY);
        if (componentRegistry == null) {
            componentRegistry = new ComponentRegistry(null);
        }
        WebInjectionContainer injectionContainer = new WebInjectionContainer((ClassLoader)module.getClassLoader(), componentRegistry);
        String securityContextId = deploymentUnit.getName();
        if (deploymentUnit.getParent() != null) {
            securityContextId = deploymentUnit.getParent().getName() + "!" + securityContextId;
        }
        String pathName = UndertowDeploymentProcessor.pathNameOfDeployment(deploymentUnit, metaData);
        String metaDataSecurityDomain = metaData.getSecurityDomain();
        if (metaDataSecurityDomain == null) {
            metaDataSecurityDomain = this.getJBossAppSecurityDomain(deploymentUnit);
        }
        if (metaDataSecurityDomain != null) {
            metaDataSecurityDomain = metaDataSecurityDomain.trim();
        }
        String securityDomain = metaDataSecurityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain);
        ServiceName deploymentServiceName = UndertowService.deploymentServiceName(hostName, pathName);
        UndertowDeploymentInfoService undertowDeploymentInfoService = UndertowDeploymentInfoService.builder().setAttributes((List)deploymentUnit.getAttachment(ServletContextAttribute.ATTACHMENT_KEY)).setClassReflectionIndex(deploymentClassIndex).setComponentRegistry(componentRegistry).setContextPath(pathName).setDeploymentName(deploymentUnit.getName()).setDeploymentRoot(deploymentRoot).setInjectionContainer(injectionContainer).setMergedMetaData(warMetaData.getMergedJBossWebMetaData()).setModule(module).setScisMetaData(scisMetaData).setSecurityContextId(securityContextId).setSecurityDomain(securityDomain).setSharedTlds((List)deploymentUnit.getAttachment(SharedTldsMetaDataBuilder.ATTACHMENT_KEY)).setTldsMetaData((TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY)).setSetupActions(setupActions).createUndertowDeploymentInfoService();
        ServiceName deploymentInfoServiceName = deploymentServiceName.append(UndertowDeploymentInfoService.SERVICE_NAME);
        ServiceBuilder infoBuilder = serviceTarget.addService(deploymentInfoServiceName, (Service)undertowDeploymentInfoService).addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{this.defaultContainer}), ServletContainerService.class, undertowDeploymentInfoService.getContainer()).addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}), SecurityDomainContext.class, undertowDeploymentInfoService.getSecurityDomainContextValue()).addDependency(UndertowService.UNDERTOW, UndertowService.class, undertowDeploymentInfoService.getUndertowService()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, BufferCacheService.SERVICE_NAME.append(new String[]{"default"}), DirectBufferCache.class, undertowDeploymentInfoService.getBufferCacheInjectedValue()).addDependencies((Iterable)deploymentUnit.getAttachmentList(Attachments.WEB_DEPENDENCIES));
        if (metaData.getDistributable() != null && (factory = (factoryService = new DistributedCacheManagerFactoryService()).getValue()) != null) {
            ServiceName factoryServiceName = deploymentServiceName.append(new String[]{"session"});
            infoBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, factoryServiceName, DistributedCacheManagerFactory.class, undertowDeploymentInfoService.getDistributedCacheManagerFactoryInjectedValue());
            ServiceBuilder factoryBuilder = serviceTarget.addService(factoryServiceName, (Service)factoryService);
            boolean enabled = factory.addDeploymentDependencies(deploymentServiceName, deploymentUnit.getServiceRegistry(), serviceTarget, factoryBuilder, metaData);
            factoryBuilder.setInitialMode(enabled ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.NEVER).install();
        }
        infoBuilder.install();
        ServiceName hostServiceName = UndertowService.virtualHostName(this.defaultServer, hostName);
        UndertowDeploymentService service = new UndertowDeploymentService(injectionContainer);
        ServiceBuilder builder = serviceTarget.addService(deploymentServiceName, (Service)service).addDependencies(dependentComponents).addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{this.defaultContainer}), ServletContainerService.class, service.getContainer()).addDependency(hostServiceName, Host.class, service.getHost()).addDependencies((Iterable)deploymentUnit.getAttachmentList(Attachments.WEB_DEPENDENCIES)).addDependency(deploymentInfoServiceName, DeploymentInfo.class, service.getDeploymentInfoInjectedValue());
        deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, (Object)deploymentServiceName);
        if (deploymentUnit.hasAttachment(Attachments.OSGI_MANIFEST)) {
            builder.setInitialMode(ServiceController.Mode.NEVER);
            UndertowDeploymentService.ContextActivatorImpl activator = new UndertowDeploymentService.ContextActivatorImpl((ServiceController<UndertowDeploymentService>)builder.install());
            deploymentUnit.putAttachment(ContextActivator.ATTACHMENT_KEY, (Object)activator);
        } else {
            builder.setInitialMode(ServiceController.Mode.ACTIVE);
            builder.install();
        }
        ModelNode node = deploymentUnit.getDeploymentSubsystemModel("undertow");
        node.get(DeploymentDefinition.CONTEXT_ROOT.getName()).set("".equals(pathName) ? "/" : pathName);
        node.get(DeploymentDefinition.VIRTUAL_HOST.getName()).set(hostName);
        this.processManagement(deploymentUnit, metaData);
    }

    static String pathNameOfDeployment(DeploymentUnit deploymentUnit, JBossWebMetaData metaData) {
        String pathName;
        if (metaData.getContextRoot() == null) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            pathName = description != null ? "/" + description.getModuleName() : "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if ("/".equals(pathName)) {
                pathName = "";
            } else if (pathName.length() > 0 && pathName.charAt(0) != '/') {
                pathName = "/" + pathName;
            }
        }
        return pathName;
    }

    void processManagement(DeploymentUnit unit, JBossWebMetaData metaData) {
        for (JBossServletMetaData servlet : metaData.getServlets()) {
            try {
                String name = servlet.getName();
                ModelNode node = unit.createDeploymentSubModel("undertow", PathElement.pathElement((String)"servlet", (String)name));
                node.get("servlet-class").set(servlet.getServletClass());
                node.get("servlet-name").set(servlet.getServletName());
            }
            catch (Exception e) {}
        }
    }

    private String getJBossAppSecurityDomain(DeploymentUnit deploymentUnit) {
        EarMetaData jbossAppMetaData;
        String securityDomain = null;
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent != null && (jbossAppMetaData = (EarMetaData)parent.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA)) instanceof JBossAppMetaData) {
            securityDomain = ((JBossAppMetaData)jbossAppMetaData).getSecurityDomain();
        }
        return securityDomain;
    }
}

