/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.handlers.Handler;

public class FileHandler
extends Handler {
    private static final AttributeDefinition PATH = new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setAllowNull(true).setAllowExpression(true).build();
    private static final AttributeDefinition CACHE_BUFFER_SIZE = new SimpleAttributeDefinitionBuilder("cache-buffer-size", ModelType.LONG).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(1024)).build();
    private static final AttributeDefinition CACHE_BUFFERS = new SimpleAttributeDefinitionBuilder("cache-buffers", ModelType.LONG).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(1024)).build();
    private static final AttributeDefinition DIRECTORY_LISTING = new SimpleAttributeDefinitionBuilder("directory-listing", ModelType.BOOLEAN).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(false)).build();

    FileHandler() {
        super("file");
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(PATH, CACHE_BUFFER_SIZE, CACHE_BUFFERS, DIRECTORY_LISTING);
    }

    @Override
    public HttpHandler createHandler(OperationContext context, ModelNode model) throws OperationFailedException {
        String path = PATH.resolveModelAttribute(context, model).asString();
        boolean directoryListing = DIRECTORY_LISTING.resolveModelAttribute(context, model).asBoolean();
        UndertowLogger.ROOT_LOGGER.infof("Creating file handler for path %s", (Object)path);
        FileResourceManager resourceManager = new FileResourceManager(Paths.get(path, new String[0]));
        ResourceHandler handler = new ResourceHandler();
        handler.setResourceManager((ResourceManager)resourceManager);
        handler.setDirectoryListingEnabled(directoryListing);
        return handler;
    }
}

