/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;

public class SecurityContextAssociationHandler
implements HttpHandler {
    private final Map<String, Set<String>> principleVsRoleMap;
    private final Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap;
    private final String contextId;
    private final HttpHandler next;

    public SecurityContextAssociationHandler(Map<String, Set<String>> principleVsRoleMap, Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap, String contextId, HttpHandler next) {
        this.principleVsRoleMap = principleVsRoleMap;
        this.runAsIdentityMetaDataMap = runAsIdentityMetaDataMap;
        this.contextId = contextId;
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String previousContextID;
        block4: {
            SecurityContext sc = (SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT);
            previousContextID = null;
            RunAsIdentityMetaData identity = null;
            try {
                SecurityActions.setSecurityContextOnAssociation(sc);
                ServletChain servlet = ((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getCurrentServlet();
                identity = this.runAsIdentityMetaDataMap.get(servlet.getManagedServlet().getServletInfo().getName());
                RunAsIdentity runAsIdentity = null;
                if (identity != null) {
                    UndertowLogger.ROOT_LOGGER.tracef("%s, runAs: %s", servlet.getManagedServlet().getServletInfo().getName(), identity);
                    runAsIdentity = new RunAsIdentity(identity.getRoleName(), identity.getPrincipalName(), identity.getRunAsRoles());
                }
                SecurityActions.pushRunAsIdentity(runAsIdentity);
                previousContextID = this.setContextID(this.contextId);
                this.next.handleRequest(exchange);
                if (identity == null) break block4;
            }
            catch (Throwable throwable) {
                if (identity != null) {
                    SecurityActions.popRunAsIdentity();
                }
                SecurityActions.clearSecurityContext();
                SecurityRolesAssociation.setSecurityRoles(null);
                this.setContextID(previousContextID);
                throw throwable;
            }
            SecurityActions.popRunAsIdentity();
        }
        SecurityActions.clearSecurityContext();
        SecurityRolesAssociation.setSecurityRoles(null);
        this.setContextID(previousContextID);
    }

    private String setContextID(String contextID) {
        SetContextIDAction action = new SetContextIDAction(contextID);
        return AccessController.doPrivileged(action);
    }

    public static HandlerWrapper wrapper(final Map<String, Set<String>> principleVsRoleMap, final Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap, final String contextId) {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new SecurityContextAssociationHandler(principleVsRoleMap, runAsIdentityMetaDataMap, contextId, handler);
            }
        };
    }

    private static class SetContextIDAction
    implements PrivilegedAction<String> {
        private String contextID;

        SetContextIDAction(String contextID) {
            this.contextID = contextID;
        }

        @Override
        public String run() {
            String currentContextID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return currentContextID;
        }
    }
}

