/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.util.Map;
import javax.servlet.ServletException;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.logging.Logger;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.extension.undertow.session.ClusteredSession;
import org.wildfly.extension.undertow.session.SessionManager;
import org.wildfly.extension.undertow.session.SessionReplicationContext;
import org.wildfly.extension.undertow.session.SnapshotManager;

public class ClusteredSessionHandler
implements HttpHandler {
    protected static final Logger log = Logger.getLogger(ClusteredSessionHandler.class);
    private final SessionManager manager;
    private final BatchingManager tm;
    private final HttpHandler next;

    public ClusteredSessionHandler(SessionManager manager, BatchingManager tm, HttpHandler next) {
        this.next = next;
        assert (manager != null) : UndertowMessages.MESSAGES.nullParamter("manager");
        this.manager = manager;
        this.tm = tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("handling request %s", (Object)exchange.getRequestURI());
        }
        SessionReplicationContext.enterWebapp(exchange, true);
        boolean startedBatch = this.startBatchTransaction();
        try {
            HttpServletRequestImpl request = ((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getOriginalRequest();
            String requestedId = request.getServletContext().getSessionCookieConfig().findSessionId(exchange);
            if (requestedId != null) {
                this.manager.getSession(exchange, (SessionConfig)request.getServletContext().getSessionCookieConfig());
            }
            this.next.handleRequest(exchange);
        }
        finally {
            try {
                SessionReplicationContext ctx = SessionReplicationContext.exitWebapp();
                if (ctx.getSoleSnapshotManager() != null) {
                    ctx.getSoleSnapshotManager().snapshot(ctx.getSoleSession());
                } else {
                    this.handleCrossContextSessions(ctx);
                }
            }
            finally {
                if (startedBatch) {
                    this.tm.endBatch();
                }
            }
        }
    }

    private boolean startBatchTransaction() throws ServletException {
        boolean started = false;
        try {
            if (this.tm != null && !this.tm.isBatchInProgress()) {
                this.tm.startBatch();
                started = true;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw UndertowMessages.MESSAGES.failToStartBatchTransaction(e);
        }
        return started;
    }

    private void handleCrossContextSessions(SessionReplicationContext ctx) {
        Map<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> sessions = ctx.getCrossContextSessions();
        if (sessions != null && sessions.size() > 0) {
            for (Map.Entry<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> entry : sessions.entrySet()) {
                entry.getValue().snapshot(entry.getKey());
            }
        }
    }
}

