/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.session.ClusteredSession;
import org.wildfly.extension.undertow.session.SessionManager;
import org.wildfly.extension.undertow.session.SnapshotManager;

public class IntervalSnapshotManager
extends SnapshotManager
implements Runnable {
    private final int interval;
    private final Set<ClusteredSession<? extends OutgoingDistributableSessionData>> sessions = new LinkedHashSet<ClusteredSession<? extends OutgoingDistributableSessionData>>();
    private volatile Thread thread = null;
    private volatile boolean processingAllowed = false;
    private volatile boolean threadDone = false;
    private final ClassLoader classLoader;

    public IntervalSnapshotManager(SessionManager manager, ClassLoader classLoader, String path) {
        super(manager, path);
        this.classLoader = classLoader;
        this.interval = 1000;
    }

    public IntervalSnapshotManager(SessionManager manager, ClassLoader classLoader, String path, int interval) {
        super(manager, path);
        this.interval = interval;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshot(ClusteredSession<? extends OutgoingDistributableSessionData> session) {
        try {
            Set<ClusteredSession<? extends OutgoingDistributableSessionData>> set = this.sessions;
            synchronized (set) {
                this.sessions.add(session);
            }
        }
        catch (Exception e) {
            UndertowLogger.ROOT_LOGGER.failedQueueingSessionReplication(session, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSessions() {
        HashSet<ClusteredSession<? extends OutgoingDistributableSessionData>> toProcess = null;
        Set<ClusteredSession<? extends OutgoingDistributableSessionData>> set = this.sessions;
        synchronized (set) {
            toProcess = new HashSet<ClusteredSession<? extends OutgoingDistributableSessionData>>(this.sessions);
            this.sessions.clear();
        }
        SessionManager mgr = this.getManager();
        for (ClusteredSession clusteredSession : toProcess) {
            if (!this.processingAllowed) break;
            try {
                mgr.storeSession(clusteredSession);
            }
            catch (Exception e) {
                UndertowLogger.ROOT_LOGGER.failedToStoreSession(clusteredSession.getRealId(), e);
            }
        }
    }

    @Override
    public void start() {
        this.processingAllowed = true;
        this.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.processingAllowed = false;
        this.stopThread();
        Set<ClusteredSession<? extends OutgoingDistributableSessionData>> set = this.sessions;
        synchronized (set) {
            this.sessions.clear();
        }
    }

    protected void startThread() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "ClusteredSessionDistributor[" + this.getContextPath() + "]");
        this.thread.setDaemon(true);
        this.thread.setContextClassLoader(this.classLoader);
        this.threadDone = false;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopThread() {
        boolean intr = false;
        try {
            if (this.thread == null) {
                return;
            }
            this.threadDone = true;
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                intr = true;
            }
            this.thread = null;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean intr = false;
        try {
            while (!this.threadDone) {
                try {
                    Thread.sleep(this.interval);
                    this.processSessions();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    if (this.threadDone) continue;
                    UndertowLogger.ROOT_LOGGER.exceptionProcessingSessions(ie);
                }
                catch (Exception e) {
                    UndertowLogger.ROOT_LOGGER.exceptionProcessingSessions(e);
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

