/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;

public class LockingHandler
implements HttpHandler {
    protected static final Logger log = Logger.getLogger(LockingHandler.class);
    private final Lock lock;
    private final HttpHandler next;

    public LockingHandler(Lock lock, HttpHandler next) {
        this.lock = lock;
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        block7: {
            if (log.isTraceEnabled()) {
                log.tracef("handling request %s", (Object)exchange.getRequestURI());
            }
            try {
                if (this.lock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        this.next.handleRequest(exchange);
                        break block7;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                HttpServletResponse response = (HttpServletResponse)((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletResponse();
                response.sendError(503);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

