/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.clustering.web.DistributableSessionMetadata;
import org.jboss.as.clustering.web.OutgoingSessionGranularitySessionData;
import org.wildfly.extension.undertow.session.ClusteredSession;
import org.wildfly.extension.undertow.session.DistributableSessionManager;
import org.wildfly.extension.undertow.session.OutgoingDistributableSessionDataImpl;

class SessionBasedClusteredSession
extends ClusteredSession<OutgoingSessionGranularitySessionData> {
    static final long serialVersionUID = 3200976125245487256L;
    protected static final String info = "SessionBasedClusteredSession/1.0";

    public SessionBasedClusteredSession(DistributableSessionManager<OutgoingSessionGranularitySessionData> manager) {
        super(manager);
    }

    @Override
    protected OutgoingSessionGranularitySessionData getOutgoingSessionData() {
        Map<String, Object> attrs = this.isSessionAttributeMapDirty() ? this.getSessionAttributeMap() : null;
        DistributableSessionMetadata metadata = this.isSessionMetadataDirty() ? this.getSessionMetadata() : null;
        Long timestamp = attrs != null || metadata != null || this.getMustReplicateTimestamp() ? Long.valueOf(this.getSessionTimestamp()) : null;
        return new OutgoingData(this.getRealId(), this.getVersion(), timestamp, metadata, attrs);
    }

    @Override
    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        if (localCall) {
            this.sessionAttributesDirty();
        }
        return this.getAttributesInternal().remove(name);
    }

    @Override
    protected Object setAttributeInternal(String name, Object value) {
        this.sessionAttributesDirty();
        return this.getAttributesInternal().put(name, value);
    }

    private Map<String, Object> getSessionAttributeMap() {
        ConcurrentHashMap<String, Object> attrs = new ConcurrentHashMap<String, Object>(this.getAttributesInternal());
        this.removeExcludedAttributes(attrs);
        return attrs;
    }

    private static class OutgoingData
    extends OutgoingDistributableSessionDataImpl
    implements OutgoingSessionGranularitySessionData {
        private final Map<String, Object> attributes;

        public OutgoingData(String realId, int version, Long timestamp, DistributableSessionMetadata metadata, Map<String, Object> attributes) {
            super(realId, version, timestamp, metadata);
            this.attributes = attributes;
        }

        public Map<String, Object> getSessionAttributes() {
            return this.attributes;
        }
    }
}

