/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.util.Collections;
import java.util.List;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JCAValidatorFactory
implements ValidatorFactory {
    private final Configuration<?> configuration;
    private final ClassLoader classLoader;
    private volatile ValidatorFactory delegate;

    public JCAValidatorFactory(ClassLoader classLoader) {
        this(null, classLoader);
    }

    public JCAValidatorFactory(Configuration<?> configuration, ClassLoader classLoader) {
        this.configuration = configuration;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            JCAValidatorFactory jCAValidatorFactory = this;
            synchronized (jCAValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory initFactory() {
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            if (this.configuration == null) {
                ValidatorFactory factory;
                ConstraintMapping mapping = new ConstraintMapping();
                HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).providerResolver((ValidationProviderResolver)new JBossProviderResolver()).configure();
                config.addMapping(mapping);
                ValidatorFactory validatorFactory = factory = config.buildValidatorFactory();
                return validatorFactory;
            }
            ValidatorFactory validatorFactory = this.configuration.buildValidatorFactory();
            return validatorFactory;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public ValidatorContext usingContext() {
        return this.getDelegate().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.getDelegate().unwrap(clazz);
    }

    private static final class JBossProviderResolver
    implements ValidationProviderResolver {
        private JBossProviderResolver() {
        }

        public List<ValidationProvider<?>> getValidationProviders() {
            return Collections.singletonList(new HibernateValidator());
        }
    }
}

