/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerFactory;

@Deprecated
public class TransactionManagerLocator
implements TransactionManagerFactory {
    private static final Logger log = Logger.getLogger(TransactionManagerLocator.class);
    private static final String JNDI_NAME = "java:/TransactionManager";
    private static TransactionManagerLocator instance = new TransactionManagerLocator();
    private TransactionManager tm;

    private TransactionManagerLocator() {
    }

    public static TransactionManagerLocator getInstance() {
        return instance;
    }

    public static TransactionManager locateTransactionManager() {
        return TransactionManagerLocator.getInstance().locate();
    }

    public static TransactionManager locateTransactionManager(boolean throwExceptionIfUnableToLocate) {
        return TransactionManagerLocator.getInstance().locate(throwExceptionIfUnableToLocate);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.locate();
    }

    public TransactionManager locate() {
        return this.locate(true);
    }

    public TransactionManager locate(boolean throwExceptionIfUnableToLocate) {
        if (this.tm != null) {
            return this.tm;
        }
        TransactionManager result = this.tryJNDI();
        if (result == null) {
            result = this.usePrivateAPI();
        }
        if (result == null && throwExceptionIfUnableToLocate) {
            throw new RuntimeException("Unable to locate the transaction manager");
        }
        return result;
    }

    protected TransactionManager tryJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup(JNDI_NAME);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Got a transaction manager from jndi " + this.tm));
            }
        }
        catch (NamingException e) {
            log.debug((Object)"Unable to lookup: java:/TransactionManager", (Throwable)e);
        }
        return this.tm;
    }

    protected TransactionManager usePrivateAPI() {
        try {
            Class<?> clazz = Class.forName("org.jboss.tm.TxManager");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            TransactionManager result = (TransactionManager)method.invoke(null, null);
            log.warn((Object)("Using the old JBoss transaction manager " + this.tm));
            return result;
        }
        catch (Exception e) {
            log.debug((Object)"Unable to instantiate legacy transaction manager", (Throwable)e);
            return null;
        }
    }
}

