/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;

public abstract class CommandHandlerWithArguments
implements CommandHandler {
    private int maxArgumentIndex = -1;
    private Map<String, CommandArgument> args = Collections.emptyMap();

    public void addArgument(CommandArgument arg) {
        if (arg.getIndex() > -1) {
            int n = this.maxArgumentIndex = arg.getIndex() > this.maxArgumentIndex ? arg.getIndex() : this.maxArgumentIndex;
        }
        if (arg.getFullName() == null) {
            throw new IllegalArgumentException("Full name can't be null");
        }
        if (this.args.isEmpty()) {
            this.args = new HashMap<String, CommandArgument>();
        }
        this.args.put(arg.getFullName(), arg);
    }

    @Override
    public CommandArgument getArgument(CommandContext ctx, String name) {
        return this.args.get(name);
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return this.args.containsKey(name);
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        throw new UnsupportedOperationException("not used yet");
    }

    @Override
    public Collection<CommandArgument> getArguments(CommandContext ctx) {
        return this.args.values();
    }

    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        Set<String> specifiedNames = ctx.getParsedCommandLine().getPropertyNames();
        if (!this.args.keySet().containsAll(specifiedNames)) {
            HashSet<String> unrecognized = new HashSet<String>(specifiedNames);
            unrecognized.removeAll(this.args.keySet());
            throw new CommandFormatException("Unrecognized arguments: " + unrecognized);
        }
        if (ctx.getParsedCommandLine().getOtherProperties().size() - 1 > this.maxArgumentIndex) {
            throw new CommandFormatException("The command accepts " + (this.maxArgumentIndex + 1) + " unnamed argument(s) but received: " + ctx.getParsedCommandLine().getOtherProperties());
        }
    }
}

