/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.ClientWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutcomeTargetRenderer
extends HtmlBasicRenderer {
    @Override
    public void decode(FacesContext context, UIComponent component) {
    }

    protected void renderPassThruAttributes(FacesContext ctx, ResponseWriter writer, UIComponent component, Attribute[] attributes, List excludedAttributes) throws IOException {
        RenderKitUtils.renderPassThruAttributes(ctx, writer, component, attributes);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component, excludedAttributes);
    }

    protected String getLabel(UIComponent component) {
        Object value = ((UIOutcomeTarget)component).getValue();
        return value != null ? value.toString() : "";
    }

    protected String getFragment(UIComponent component) {
        String fragment = (String)component.getAttributes().get("fragment");
        String string = fragment = fragment != null ? fragment.trim() : "";
        if (fragment.length() > 0) {
            fragment = "#" + fragment;
        }
        return fragment;
    }

    @Override
    protected Object getValue(UIComponent component) {
        return ((UIOutcomeTarget)component).getValue();
    }

    protected boolean isIncludeViewParams(UIComponent component, NavigationCase navcase) {
        return ((UIOutcomeTarget)component).isIncludeViewParams() || navcase.isIncludeViewParams();
    }

    protected NavigationCase getNavigationCase(FacesContext context, UIComponent component) {
        NavigationHandler navHandler = context.getApplication().getNavigationHandler();
        if (!(navHandler instanceof ConfigurableNavigationHandler)) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "jsf.outcome.target.invalid.navigationhandler.type", component.getId());
            }
            return null;
        }
        String outcome = ((UIOutcomeTarget)component).getOutcome();
        if (outcome == null) {
            outcome = context.getViewRoot().getViewId();
        }
        String toFlowDocumentId = (String)component.getAttributes().get("to-flow-document-id");
        NavigationCase navCase = null;
        navCase = null == toFlowDocumentId ? ((ConfigurableNavigationHandler)navHandler).getNavigationCase(context, null, outcome) : ((ConfigurableNavigationHandler)navHandler).getNavigationCase(context, null, outcome, toFlowDocumentId);
        if (navCase == null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "jsf.outcometarget.navigation.case.not.resolved", component.getId());
        }
        return navCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEncodedTargetURL(FacesContext context, UIComponent component, NavigationCase navCase) {
        String toViewId = navCase.getToViewId(context);
        Map<String, List<String>> params = this.getParamOverrides(component);
        this.addNavigationParams(navCase, params);
        String result = null;
        boolean didDisableClientWindowRendering = false;
        ClientWindow cw = null;
        try {
            Map attrs = component.getAttributes();
            Object val = attrs.get("disableClientWindow");
            if (null != val) {
                didDisableClientWindowRendering = "true".equalsIgnoreCase(val.toString());
            }
            if (didDisableClientWindowRendering && null != (cw = context.getExternalContext().getClientWindow())) {
                cw.disableClientWindowRenderMode(context);
            }
            result = Util.getViewHandler(context).getBookmarkableURL(context, toViewId, params, this.isIncludeViewParams(component, navCase));
        }
        finally {
            if (didDisableClientWindowRendering && null != cw) {
                cw.enableClientWindowRenderMode(context);
            }
        }
        return result;
    }

    protected void addNavigationParams(NavigationCase navCase, Map<String, List<String>> existingParams) {
        String toFlowDocumentId;
        Map navParams = navCase.getParameters();
        if (navParams != null && !navParams.isEmpty()) {
            for (Map.Entry entry : navParams.entrySet()) {
                String navParamName = (String)entry.getKey();
                if (existingParams.containsKey(navParamName)) continue;
                existingParams.put(navParamName, (List<String>)entry.getValue());
            }
        }
        if (null != (toFlowDocumentId = navCase.getToFlowDocumentId())) {
            if ("javax.faces.flow.NullFlow".equals(toFlowDocumentId)) {
                ArrayList<String> flowDocumentIdValues = new ArrayList<String>();
                flowDocumentIdValues.add("javax.faces.flow.NullFlow");
                existingParams.put("jftfdi", flowDocumentIdValues);
            } else {
                String flowId = navCase.getFromOutcome();
                ArrayList<String> flowDocumentIdValues = new ArrayList<String>();
                flowDocumentIdValues.add(toFlowDocumentId);
                existingParams.put("jftfdi", flowDocumentIdValues);
                ArrayList<String> flowIdValues = new ArrayList<String>();
                flowIdValues.add(flowId);
                existingParams.put("jffi", flowIdValues);
            }
        }
    }

    protected Map<String, List<String>> getParamOverrides(UIComponent component) {
        HtmlBasicRenderer.Param[] declaredParams;
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (HtmlBasicRenderer.Param candidate : declaredParams = this.getParamList(component)) {
            if (candidate.name == null || candidate.name.trim().length() <= 0) continue;
            candidate.name = candidate.name.trim();
            ArrayList<String> values = (ArrayList<String>)params.get(candidate.name);
            if (values == null) {
                values = new ArrayList<String>();
                params.put(candidate.name, values);
            }
            values.add(candidate.value);
        }
        return params;
    }
}

