/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.jsr.EncodingFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;

public class Encoding
implements Closeable {
    private final Map<Class<?>, List<InstanceHandle<? extends Encoder>>> binaryEncoders;
    private final Map<Class<?>, List<InstanceHandle<? extends Decoder>>> binaryDecoders;
    private final Map<Class<?>, List<InstanceHandle<? extends Encoder>>> textEncoders;
    private final Map<Class<?>, List<InstanceHandle<? extends Decoder>>> textDecoders;

    public Encoding(Map<Class<?>, List<InstanceHandle<? extends Encoder>>> binaryEncoders, Map<Class<?>, List<InstanceHandle<? extends Decoder>>> binaryDecoders, Map<Class<?>, List<InstanceHandle<? extends Encoder>>> textEncoders, Map<Class<?>, List<InstanceHandle<? extends Decoder>>> textDecoders) {
        this.binaryEncoders = binaryEncoders;
        this.binaryDecoders = binaryDecoders;
        this.textEncoders = textEncoders;
        this.textDecoders = textDecoders;
    }

    public boolean canEncodeText(Class<?> type) {
        if (EncodingFactory.isPrimitiveOrBoxed(type)) {
            return true;
        }
        return this.textEncoders.containsKey(type);
    }

    public boolean canDecodeText(Class<?> type) {
        if (EncodingFactory.isPrimitiveOrBoxed(type)) {
            return true;
        }
        return this.textDecoders.containsKey(type);
    }

    public boolean canEncodeBinary(Class<?> type) {
        return this.binaryEncoders.containsKey(type);
    }

    public boolean canDecodeDinary(Class<?> type) {
        return this.textDecoders.containsKey(type);
    }

    public Object decodeText(Class<?> targetType, String message) throws DecodeException {
        if (EncodingFactory.isPrimitiveOrBoxed(targetType)) {
            return this.decodePrimitive(targetType, message);
        }
        List<InstanceHandle<? extends Decoder>> decoders = this.textDecoders.get(targetType);
        if (decoders != null) {
            for (InstanceHandle<? extends Decoder> decoderHandle : decoders) {
                Decoder decoder = (Decoder)decoderHandle.getInstance();
                if (decoder instanceof Decoder.Text) {
                    if (!((Decoder.Text)decoder).willDecode(message)) continue;
                    return ((Decoder.Text)decoder).decode(message);
                }
                try {
                    return ((Decoder.TextStream)decoder).decode((Reader)new StringReader(message));
                }
                catch (IOException e) {
                    throw new DecodeException(message, "Could not decode string", (Throwable)e);
                }
            }
        }
        throw new DecodeException(message, "Could not decode string");
    }

    private Object decodePrimitive(Class<?> targetType, String message) throws DecodeException {
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return new Boolean(message);
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            if (message.length() > 1) {
                throw new DecodeException(message, "Character message larger than 1 character");
            }
            return new Character(message.charAt(0));
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return new Byte(message);
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return new Short(message);
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return new Integer(message);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return new Long(message);
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return new Float(message);
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return new Double(message);
        }
        return null;
    }

    public Object decodeBinary(Class<?> targetType, byte[] bytes) throws DecodeException {
        List<InstanceHandle<? extends Decoder>> decoders = this.binaryDecoders.get(targetType);
        if (decoders != null) {
            for (InstanceHandle<? extends Decoder> decoderHandle : decoders) {
                Decoder decoder = (Decoder)decoderHandle.getInstance();
                if (decoder instanceof Decoder.Binary) {
                    if (!((Decoder.Binary)decoder).willDecode(ByteBuffer.wrap(bytes))) continue;
                    return ((Decoder.Binary)decoder).decode(ByteBuffer.wrap(bytes));
                }
                try {
                    return ((Decoder.BinaryStream)decoder).decode((InputStream)new ByteArrayInputStream(bytes));
                }
                catch (IOException e) {
                    throw new DecodeException(ByteBuffer.wrap(bytes), "Could not decode binary", (Throwable)e);
                }
            }
        }
        throw new DecodeException(ByteBuffer.wrap(bytes), "Could not decode binary");
    }

    public String encodeText(Object o) throws EncodeException {
        Iterator<InstanceHandle<? extends Encoder>> i$;
        if (EncodingFactory.isPrimitiveOrBoxed(o.getClass())) {
            return o.toString();
        }
        List<InstanceHandle<? extends Encoder>> decoders = this.textEncoders.get(o.getClass());
        if (decoders != null && (i$ = decoders.iterator()).hasNext()) {
            InstanceHandle<? extends Encoder> decoderHandle = i$.next();
            Encoder decoder = (Encoder)decoderHandle.getInstance();
            if (decoder instanceof Encoder.Text) {
                return ((Encoder.Text)decoder).encode(o);
            }
            try {
                StringWriter out = new StringWriter();
                ((Encoder.TextStream)decoder).encode(o, (Writer)out);
                return out.toString();
            }
            catch (IOException e) {
                throw new EncodeException(o, "Could not encode text", (Throwable)e);
            }
        }
        throw new EncodeException(o, "Could not encode text");
    }

    public ByteBuffer encodeBinary(Object o) throws EncodeException {
        Iterator<InstanceHandle<? extends Encoder>> i$;
        List<InstanceHandle<? extends Encoder>> decoders = this.binaryEncoders.get(o.getClass());
        if (decoders != null && (i$ = decoders.iterator()).hasNext()) {
            InstanceHandle<? extends Encoder> decoderHandle = i$.next();
            Encoder decoder = (Encoder)decoderHandle.getInstance();
            if (decoder instanceof Encoder.Binary) {
                return ((Encoder.Binary)decoder).encode(o);
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ((Encoder.BinaryStream)decoder).encode(o, (OutputStream)out);
                return ByteBuffer.wrap(out.toByteArray());
            }
            catch (IOException e) {
                throw new EncodeException(o, "Could not encode binary", (Throwable)e);
            }
        }
        throw new EncodeException(o, "Could not encode binary");
    }

    @Override
    public void close() {
        for (Map.Entry<Class<?>, List<InstanceHandle<Decoder>>> entry : this.binaryDecoders.entrySet()) {
            for (InstanceHandle<? extends Decoder> val : entry.getValue()) {
                ((Decoder)val.getInstance()).destroy();
                val.release();
            }
        }
        for (Map.Entry<Class<?>, List<InstanceHandle<Decoder>>> entry : this.textDecoders.entrySet()) {
            for (InstanceHandle<? extends Decoder> val : entry.getValue()) {
                ((Decoder)val.getInstance()).destroy();
                val.release();
            }
        }
        for (Map.Entry<Class<?>, List<InstanceHandle<Decoder>>> entry : this.binaryEncoders.entrySet()) {
            for (InstanceHandle<? extends Decoder> val : entry.getValue()) {
                ((Encoder)val.getInstance()).destroy();
                val.release();
            }
        }
        for (Map.Entry<Class<?>, List<InstanceHandle<Decoder>>> entry : this.textEncoders.entrySet()) {
            for (InstanceHandle<? extends Decoder> val : entry.getValue()) {
                ((Encoder)val.getInstance()).destroy();
                val.release();
            }
        }
    }
}

