/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.remote.ExternalSaslServerFactory;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteAuthLogger;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.security.AuthorizingCallbackHandler;
import org.jboss.remoting3.security.InetAddressPrincipal;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ServerConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final ServerAuthenticationProvider serverAuthenticationProvider;
    private final OptionMap optionMap;
    private final AccessControlContext accessControlContext;
    private final AtomicInteger retryCount = new AtomicInteger(8);
    private final String serverName;

    ServerConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, ServerAuthenticationProvider serverAuthenticationProvider, OptionMap optionMap, AccessControlContext accessControlContext) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.serverAuthenticationProvider = serverAuthenticationProvider;
        this.optionMap = optionMap;
        this.accessControlContext = accessControlContext;
        this.serverName = optionMap.contains(RemotingOptions.SERVER_NAME) ? (String)optionMap.get(RemotingOptions.SERVER_NAME) : ((InetSocketAddress)connection.getChannel().getLocalAddress(InetSocketAddress.class)).getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ConnectedMessageChannel channel) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
            sendBuffer.put((byte)0);
            ProtocolUtils.writeString(sendBuffer, (byte)0, this.serverName);
            sendBuffer.flip();
            this.connection.setReadListener(new Initial(), true);
            this.connection.send(pooled);
            ok = true;
            return;
        }
        catch (BufferUnderflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        catch (BufferOverflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    private void saslDispose(SaslServer saslServer) {
        if (saslServer != null) {
            try {
                saslServer.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.server.trace("Failure disposing of SaslServer", e);
            }
        }
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslServer saslServer;
        private final AuthorizingCallbackHandler authorizingCallbackHandler;
        private final String remoteEndpointName;
        private final int behavior;

        Authentication(SaslServer saslServer, AuthorizingCallbackHandler authorizingCallbackHandler, String remoteEndpointName, int behavior) {
            this.saslServer = saslServer;
            this.authorizingCallbackHandler = authorizingCallbackHandler;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledBuffer = ServerConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ServerConnectionOpenListener.this.connection.handleException(e);
                    ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                    pooledBuffer.free();
                    return;
                }
                if (res == -1) {
                    RemoteLogger.log.trace("Received connection end-of-stream");
                    ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                    ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.server.tracef("Received %s", buffer);
                buffer.flip();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -1: {
                        RemoteLogger.server.trace("Server received connection close request");
                        ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                        return;
                    }
                    case 4: {
                        RemoteLogger.server.tracef("Server received authentication response", new Object[0]);
                        ServerConnectionOpenListener.this.connection.getChannel().suspendReads();
                        ServerConnectionOpenListener.this.connection.getExecutor().execute(new AuthStepRunnable(false, this.saslServer, this.authorizingCallbackHandler, buffer, this.remoteEndpointName, this.behavior));
                        return;
                    }
                    case 1: {
                        RemoteLogger.server.trace("Server received capabilities request (cancelling authentication)");
                        ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                        Initial initial = new Initial();
                        ServerConnectionOpenListener.this.connection.setReadListener(initial, true);
                        initial.handleClientCapabilities(buffer);
                        initial.sendCapabilities();
                        return;
                    }
                }
                RemoteLogger.server.unknownProtocolId(msgType);
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
            }
            catch (BufferUnderflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                return;
            }
            catch (BufferOverflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                return;
            }
            finally {
                pooledBuffer.free();
            }
        }
    }

    final class AuthStepRunnable
    implements Runnable {
        private final boolean isInitial;
        private final SaslServer saslServer;
        private final AuthorizingCallbackHandler authorizingCallbackHandler;
        private final ByteBuffer buffer;
        private final String remoteEndpointName;
        private final int behavior;

        AuthStepRunnable(boolean isInitial, SaslServer saslServer, AuthorizingCallbackHandler authorizingCallbackHandler, ByteBuffer buffer, String remoteEndpointName, int behavior) {
            this.isInitial = isInitial;
            this.saslServer = saslServer;
            this.authorizingCallbackHandler = authorizingCallbackHandler;
            this.buffer = buffer;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ok = false;
            boolean close = false;
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            try {
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                int p = sendBuffer.position();
                try {
                    sendBuffer.put((byte)5);
                    if (SaslUtils.evaluateResponse((SaslServer)this.saslServer, (ByteBuffer)sendBuffer, (ByteBuffer)this.buffer)) {
                        RemoteLogger.server.tracef("Server sending authentication complete", new Object[0]);
                        final Collection<Principal> principals = this.createPrincipals();
                        final UserInfo userInfo = this.authorizingCallbackHandler.createUserInfo(principals);
                        ServerConnectionOpenListener.this.connectionProviderContext.accept(new ConnectionHandlerFactory(){

                            @Override
                            public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                Object qop = AuthStepRunnable.this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                                if (!AuthStepRunnable.this.isInitial && ("auth-int".equals(qop) || "auth-conf".equals(qop))) {
                                    ServerConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslServer)AuthStepRunnable.this.saslServer));
                                }
                                RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerConnectionOpenListener.this.connection, principals, userInfo, AuthStepRunnable.this.remoteEndpointName, AuthStepRunnable.this.behavior);
                                ServerConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                ServerConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ServerConnectionOpenListener.this.connection), false);
                                return connectionHandler;
                            }
                        });
                    } else {
                        RemoteLogger.server.tracef("Server sending authentication challenge", new Object[0]);
                        sendBuffer.put(p, (byte)3);
                        if (this.isInitial) {
                            ServerConnectionOpenListener.this.connection.setReadListener(new Authentication(this.saslServer, this.authorizingCallbackHandler, this.remoteEndpointName, this.behavior), false);
                        }
                    }
                }
                catch (Throwable e) {
                    RemoteLogger.server.tracef("Server sending authentication rejected (%s)", e);
                    sendBuffer.put(p, (byte)6);
                    ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                    if (this.isInitial) {
                        if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() <= 0) {
                            close = true;
                        }
                    }
                    ServerConnectionOpenListener.this.connection.setReadListener(new Initial(), false);
                }
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled, close);
                ServerConnectionOpenListener.this.connection.getChannel().resumeReads();
                ok = true;
                return;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }

        private Collection<Principal> createPrincipals() {
            ConnectedMessageChannel channel;
            InetSocketAddress address;
            String authorizationId;
            SSLSession session;
            LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            if (sslChannel != null && (session = sslChannel.getSslSession()) != null) {
                try {
                    principals.add(session.getPeerPrincipal());
                }
                catch (SSLPeerUnverifiedException ignored) {
                    // empty catch block
                }
            }
            if ((authorizationId = this.saslServer.getAuthorizationID()) != null) {
                principals.add(new UserPrincipal(authorizationId));
            }
            if ((address = (InetSocketAddress)(channel = ServerConnectionOpenListener.this.connection.getChannel()).getPeerAddress(InetSocketAddress.class)) != null) {
                principals.add(new InetAddressPrincipal(address.getAddress()));
            }
            return Collections.unmodifiableCollection(principals);
        }
    }

    final class Initial
    implements ChannelListener<ConnectedMessageChannel> {
        private boolean starttls;
        private Map<String, ?> propertyMap;
        private Map<String, SaslServerFactory> allowedMechanisms;
        private int version = 1;
        private String remoteEndpointName;
        private int behavior = 2;

        Initial() {
        }

        void initialiseCapabilities() {
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            boolean channelSecure = Channels.getOption((Configurable)ServerConnectionOpenListener.this.connection.getChannel(), (Option)Options.SECURE, (boolean)false);
            this.starttls = sslChannel != null && !channelSecure;
            LinkedHashMap<String, SaslServerFactory> foundMechanisms = new LinkedHashMap<String, SaslServerFactory>();
            Map propertyMap = SaslUtils.createPropertyMap((OptionMap)ServerConnectionOpenListener.this.optionMap, (boolean)channelSecure);
            Sequence saslMechs = (Sequence)ServerConnectionOpenListener.this.optionMap.get(Options.SASL_MECHANISMS);
            LinkedHashSet restrictions = saslMechs == null ? null : new LinkedHashSet(saslMechs);
            Sequence saslNoMechs = (Sequence)ServerConnectionOpenListener.this.optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
            HashSet disallowed = saslNoMechs == null ? Collections.emptySet() : new HashSet(saslNoMechs);
            Iterator factories = SaslUtils.getSaslServerFactories((ClassLoader)this.getClass().getClassLoader(), (boolean)true);
            try {
                if ((restrictions == null || restrictions.contains("EXTERNAL")) && !disallowed.contains("EXTERNAL")) {
                    SSLSession sslSession;
                    if (sslChannel != null && (sslSession = sslChannel.getSslSession()) != null) {
                        Principal principal = sslSession.getPeerPrincipal();
                        if (principal != null) {
                            foundMechanisms.put("EXTERNAL", new ExternalSaslServerFactory(principal));
                        } else {
                            RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of peer principal");
                        }
                    } else {
                        RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of SSL");
                    }
                } else {
                    RemoteLogger.server.trace("No EXTERNAL mechanism due to explicit exclusion");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            while (factories.hasNext()) {
                SaslServerFactory factory = (SaslServerFactory)factories.next();
                RemoteLogger.server.tracef("Trying SASL server factory %s", factory);
                for (String mechName : factory.getMechanismNames(propertyMap)) {
                    if (restrictions != null && !restrictions.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is not in the allowed list", mechName);
                        continue;
                    }
                    if (disallowed.contains(mechName)) {
                        RemoteLogger.server.tracef("Excluding mechanism %s because it is in the disallowed list", mechName);
                        continue;
                    }
                    if (foundMechanisms.containsKey(mechName)) {
                        RemoteLogger.server.tracef("Excluding repeated occurrence of mechanism %s", mechName);
                        continue;
                    }
                    RemoteLogger.server.tracef("Added mechanism %s", mechName);
                    foundMechanisms.put(mechName, factory);
                }
            }
            this.propertyMap = propertyMap;
            if (restrictions == null) {
                this.allowedMechanisms = foundMechanisms;
            } else {
                LinkedHashMap<String, SaslServerFactory> allowedMechanisms = new LinkedHashMap<String, SaslServerFactory>();
                for (String name : restrictions) {
                    if (!foundMechanisms.containsKey(name)) continue;
                    allowedMechanisms.put(name, (SaslServerFactory)foundMechanisms.get(name));
                }
                this.allowedMechanisms = allowedMechanisms;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            ByteBuffer receiveBuffer;
            Pooled<ByteBuffer> pooledBuffer = ServerConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                receiveBuffer = (ByteBuffer)pooledBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ServerConnectionOpenListener.this.connection.handleException(e);
                    pooledBuffer.free();
                    return;
                }
                if (res == 0) {
                    return;
                }
                if (res == -1) {
                    RemoteLogger.log.trace("Received connection end-of-stream");
                    ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                    return;
                }
                receiveBuffer.flip();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -1: {
                        RemoteLogger.server.trace("Server received connection close request");
                        ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case -16: {
                        RemoteLogger.server.trace("Server received connection alive");
                        ServerConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.server.trace("Server received connection alive ack");
                        return;
                    }
                    case 1: {
                        RemoteLogger.server.trace("Server received capabilities request");
                        this.handleClientCapabilities(receiveBuffer);
                        this.sendCapabilities();
                        return;
                    }
                    case 7: {
                        RemoteLogger.server.tracef("Server received STARTTLS request", new Object[0]);
                        Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                        boolean ok = false;
                        try {
                            ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                            sendBuffer.put(this.starttls ? (byte)7 : 8);
                            sendBuffer.flip();
                            ServerConnectionOpenListener.this.connection.send(pooled);
                            if (this.starttls) {
                                try {
                                    ServerConnectionOpenListener.this.connection.getSslChannel().startHandshake();
                                }
                                catch (IOException e) {
                                    ServerConnectionOpenListener.this.connection.handleException(e);
                                }
                            }
                            ok = true;
                            ServerConnectionOpenListener.this.connection.setReadListener(new Initial(), true);
                            return;
                        }
                        finally {
                            if (!ok) {
                                pooled.free();
                            }
                        }
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        RemoteLogger.server.unknownProtocolId(msgType);
                        ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                        return;
                    }
                }
            }
            catch (BufferUnderflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                return;
            }
            RemoteLogger.server.tracef("Server received authentication request", new Object[0]);
            if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() < 1) {
                ServerConnectionOpenListener.this.connection.handleException(new SaslException("Too many authentication failures; connection terminated"), false);
                return;
            }
            final String mechName = this.version < 1 ? Buffers.getModifiedUtf8((ByteBuffer)receiveBuffer) : ProtocolUtils.readString(receiveBuffer);
            final SaslServerFactory saslServerFactory = this.allowedMechanisms.get(mechName);
            final AuthorizingCallbackHandler callbackHandler = ServerConnectionOpenListener.this.serverAuthenticationProvider.getCallbackHandler(mechName);
            if (saslServerFactory == null || callbackHandler == null) {
                RemoteAuthLogger.authLog.rejectedInvalidMechanism(mechName);
                Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                sendBuffer.put((byte)6);
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                return;
            }
            final String protocol = ServerConnectionOpenListener.this.optionMap.contains(RemotingOptions.SASL_PROTOCOL) ? (String)ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.SASL_PROTOCOL) : "remoting";
            SaslServer saslServer = AccessController.doPrivileged(new PrivilegedAction<SaslServer>(){

                @Override
                public SaslServer run() {
                    try {
                        return saslServerFactory.createSaslServer(mechName, protocol, ServerConnectionOpenListener.this.serverName, Initial.this.propertyMap, callbackHandler);
                    }
                    catch (SaslException e) {
                        ServerConnectionOpenListener.this.connection.handleException(e);
                        return null;
                    }
                }
            }, ServerConnectionOpenListener.this.accessControlContext);
            if (saslServer == null) {
                return;
            }
            ServerConnectionOpenListener.this.connection.getChannel().suspendReads();
            ServerConnectionOpenListener.this.connection.getExecutor().execute(new AuthStepRunnable(true, saslServer, callbackHandler, receiveBuffer, this.remoteEndpointName, this.behavior));
            return;
            finally {
                pooledBuffer.free();
            }
        }

        void handleClientCapabilities(ByteBuffer receiveBuffer) {
            block6: while (receiveBuffer.hasRemaining()) {
                byte type = receiveBuffer.get();
                int len = receiveBuffer.get() & 0xFF;
                ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                switch (type) {
                    case 0: {
                        byte version = data.get();
                        RemoteLogger.server.tracef("Server received capability: version %d", version & 0xFF);
                        this.version = Math.min(1, version & 0xFF);
                        continue block6;
                    }
                    case 3: {
                        this.remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                        RemoteLogger.server.tracef("Server received capability: remote endpoint name \"%s\"", this.remoteEndpointName);
                        continue block6;
                    }
                    case 4: {
                        this.behavior |= 1;
                        this.behavior &= 0xFFFFFFFD;
                        RemoteLogger.server.tracef("Server received capability: message close protocol supported", new Object[0]);
                        continue block6;
                    }
                    case 5: {
                        this.behavior &= 0xFFFFFFFD;
                        String remoteVersionString = Buffers.getModifiedUtf8((ByteBuffer)data);
                        RemoteLogger.server.tracef("Server received capability: remote version is \"%s\"", remoteVersionString);
                        continue block6;
                    }
                }
                RemoteLogger.server.tracef("Server received unknown capability %02x", type & 0xFF);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendCapabilities() {
            if (this.allowedMechanisms == null) {
                this.initialiseCapabilities();
            }
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                sendBuffer.put((byte)1);
                ProtocolUtils.writeByte(sendBuffer, 0, this.version);
                String localEndpointName = ServerConnectionOpenListener.this.connectionProviderContext.getEndpoint().getName();
                if (localEndpointName != null) {
                    ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
                }
                if (this.starttls) {
                    ProtocolUtils.writeEmpty(sendBuffer, 2);
                }
                for (String mechName : this.allowedMechanisms.keySet()) {
                    ProtocolUtils.writeString(sendBuffer, (byte)1, mechName);
                }
                ProtocolUtils.writeEmpty(sendBuffer, 4);
                ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
                return;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }
    }
}

