/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.net.URL;
import java.util.Dictionary;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.ResourceBuilderException;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleRevisionBuilder;
import org.jboss.osgi.resolver.XBundleRevisionBuilderFactory;
import org.jboss.osgi.resolver.spi.AbstractBundleRevision;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.BundleException;

abstract class BundleStateRevision
extends AbstractBundleRevision {
    private final FrameworkState frameworkState;
    private final OSGiMetaData metadata;
    private final StorageState storageState;
    private ModuleClassLoader moduleClassLoader;
    private Dictionary<String, String> headersOnUninstall;
    private String canonicalName;

    BundleStateRevision(FrameworkState frameworkState, OSGiMetaData metadata, StorageState storageState) throws BundleException {
        assert (frameworkState != null) : "Null frameworkState";
        assert (metadata != null) : "Null metadata";
        assert (storageState != null) : "Null storageState";
        this.frameworkState = frameworkState;
        this.storageState = storageState;
        this.metadata = metadata;
        try {
            final BundleStateRevision brev = this;
            XBundleRevisionBuilderFactory factory = new XBundleRevisionBuilderFactory(){

                public XBundleRevision createResource() {
                    return brev;
                }
            };
            XBundleRevisionBuilder builder = XBundleRevisionBuilderFactory.create((XBundleRevisionBuilderFactory)factory);
            builder.loadFrom(metadata).getResource();
        }
        catch (ResourceBuilderException ex) {
            throw new BundleException(ex.getMessage(), (Throwable)ex);
        }
        this.putAttachment(IntegrationConstants.STORAGE_STATE_KEY, storageState);
        this.putAttachment(IntegrationConstants.OSGI_METADATA_KEY, metadata);
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    BundleManagerPlugin getBundleManager() {
        return this.frameworkState.getBundleManager();
    }

    public String getCanonicalName() {
        if (this.canonicalName == null) {
            String name = this.metadata.getBundleSymbolicName();
            name = name != null ? name : this.metadata.getBundleName();
            this.canonicalName = name + ":" + this.metadata.getBundleVersion();
        }
        return this.canonicalName;
    }

    int getRevisionId() {
        return this.storageState.getRevisionId();
    }

    OSGiMetaData getOSGiMetaData() {
        return this.metadata;
    }

    StorageState getStorageState() {
        return this.storageState;
    }

    Dictionary<String, String> getHeadersOnUninstall() {
        return this.headersOnUninstall;
    }

    void setHeadersOnUninstall(Dictionary<String, String> headers) {
        this.headersOnUninstall = headers;
    }

    abstract String getLocation();

    abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    abstract URL getLocalizationEntry(String var1);

    public XBundle getBundle() {
        return (XBundle)this.getAttachment(IntegrationConstants.BUNDLE_KEY);
    }

    public ModuleIdentifier getModuleIdentifier() {
        return (ModuleIdentifier)this.getAttachment(IntegrationConstants.MODULE_IDENTIFIER_KEY);
    }

    public synchronized ModuleClassLoader getModuleClassLoader() {
        if (this.moduleClassLoader == null && this.getBundle().isResolved()) {
            ModuleIdentifier identifier = this.getModuleIdentifier();
            try {
                ModuleManager moduleManager = this.getFrameworkState().getModuleManager();
                Module module = moduleManager.loadModule(identifier);
                this.moduleClassLoader = module.getClassLoader();
            }
            catch (ModuleLoadException ex) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotLoadModule(ex, identifier);
            }
        }
        return this.moduleClassLoader;
    }

    synchronized void resetModuleClassLoader() {
        this.moduleClassLoader = null;
    }

    void close() {
        VFSUtils.safeClose((Closeable)this.storageState.getRootFile());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getCanonicalName() + "]";
    }
}

