/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.List;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractBundleWiring;
import org.jboss.osgi.resolver.spi.AbstractEnvironment;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;

public final class EnvironmentImpl
extends AbstractEnvironment
implements XEnvironment {
    private final LockManager lockManager;

    public EnvironmentImpl(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installResources(XResource ... resources) {
        if (resources == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("resources");
        }
        for (XResource res : resources) {
            if (!(res instanceof XBundleRevision)) {
                throw FrameworkMessages.MESSAGES.unsupportedResourceType(res);
            }
            XBundleRevision brev = (XBundleRevision)res;
            XBundle bundle2 = brev.getBundle();
            if (bundle2 != null) continue;
            throw FrameworkMessages.MESSAGES.cannotObtainBundleFromResource(res);
        }
        LockManager.LockContext lockContext = null;
        try {
            lockContext = this.lockResources(LockManager.Method.INSTALL, resources);
            super.installResources(resources);
        }
        finally {
            this.unlockResources(lockContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallResources(XResource ... resources) {
        if (resources == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("resources");
        }
        LockManager.LockContext lockContext = null;
        try {
            lockContext = this.lockResources(LockManager.Method.UNINSTALL, resources);
            super.uninstallResources(resources);
        }
        finally {
            this.unlockResources(lockContext);
        }
    }

    public Wiring createWiring(XResource res, List<Wire> required, List<Wire> provided) {
        XBundleRevision brev = (XBundleRevision)res;
        return new AbstractBundleWiring(brev, required, provided);
    }

    private LockManager.LockContext lockResources(LockManager.Method method, XResource ... resources) {
        FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
        return this.lockManager.lockItems(method, this.getLockableItems(wireLock, resources));
    }

    private void unlockResources(LockManager.LockContext context) {
        this.lockManager.unlockItems(context);
    }

    private LockManager.LockableItem[] getLockableItems(LockManager.LockableItem item, XResource ... resources) {
        ArrayList<LockManager.LockableItem> items = new ArrayList<LockManager.LockableItem>();
        items.add(item);
        if (resources != null) {
            for (XResource res : resources) {
                XBundleRevision brev = (XBundleRevision)res;
                if (!(brev.getBundle() instanceof LockManager.LockableItem)) continue;
                items.add((LockManager.LockableItem)brev.getBundle());
            }
        }
        return items.toArray(new LockManager.LockableItem[items.size()]);
    }
}

