/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.SystemPaths;
import org.jboss.osgi.framework.spi.URLResource;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWiring;
import org.jboss.osgi.resolver.spi.AbstractBundleWire;
import org.jboss.osgi.resolver.spi.RemoveOnlyCollection;
import org.jboss.osgi.resolver.spi.ResolverHookProcessor;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

final class FallbackLoader
implements LocalLoader {
    private static ThreadLocal<Map<String, AtomicInteger>> dynamicLoadAttempts;
    private final ReentrantLock fallbackLock = new ReentrantLock();
    private final AtomicBoolean fallbackEnabled = new AtomicBoolean(true);
    private final UserBundleState hostBundle;
    private final HostBundleRevision hostRev;
    private final Set<String> importedPaths;
    private final FrameworkState frameworkState;
    private final BundleManager bundleManager;
    private List<XPackageRequirement> weavingImports;

    FallbackLoader(HostBundleRevision hostRev, Set<String> importedPaths) {
        assert (hostRev != null) : "Null hostRev";
        assert (importedPaths != null) : "Null importedPaths";
        this.importedPaths = importedPaths;
        this.hostRev = hostRev;
        this.hostBundle = hostRev.getBundleState();
        this.bundleManager = this.hostBundle.getBundleManager();
        this.frameworkState = this.hostBundle.getFrameworkState();
        hostRev.setFallbackLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setEnabled(boolean flag) {
        this.lockFallbackLoader();
        try {
            boolean bl = this.fallbackEnabled.getAndSet(flag);
            return bl;
        }
        finally {
            this.unlockFallbackLoader();
        }
    }

    void lockFallbackLoader() {
        this.fallbackLock.lock();
    }

    void unlockFallbackLoader() {
        this.fallbackLock.unlock();
    }

    void addDynamicWeavingImport(XPackageRequirement req) {
        if (this.weavingImports == null) {
            this.weavingImports = new ArrayList<XPackageRequirement>();
        }
        this.weavingImports.add(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClassLocal(String className, boolean resolve) {
        DynamicLoadContext context = new DynamicLoadContext(className.replace('.', '/') + ".class");
        try {
            this.lockFallbackLoader();
            List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(className);
            if (!this.fallbackEnabled.get() || matchingPatterns.isEmpty()) {
                Class<?> clazz = null;
                return clazz;
            }
            this.findRevisionDynamically(context, matchingPatterns);
        }
        finally {
            this.unlockFallbackLoader();
        }
        Class result = null;
        XBundleRevision brev = context.targetRevision;
        if (brev != null) {
            try {
                ModuleClassLoader moduleClassLoader = brev.getModuleClassLoader();
                result = moduleClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FrameworkLogger.LOGGER.tracef("Cannot load class [%s] from module: %s", className, brev);
                return null;
            }
            if (context.capability != null && context.requirement != null) {
                BundleCapability bcap = (BundleCapability)context.capability;
                BundleRequirement breq = (BundleRequirement)context.requirement;
                AbstractBundleWire wire = new AbstractBundleWire(bcap, breq, (BundleRevision)brev, (BundleRevision)this.hostRev);
                XWiring requirerWiring = (XWiring)this.hostBundle.adapt(BundleWiring.class);
                XWiring providerWiring = (XWiring)brev.getBundle().adapt(BundleWiring.class);
                requirerWiring.addRequiredWire((Wire)wire);
                providerWiring.addProvidedWire((Wire)wire);
            }
        }
        return result;
    }

    public Package loadPackageLocal(String name) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> loadResourceLocal(String resName) {
        DynamicLoadContext context = new DynamicLoadContext(resName);
        try {
            this.lockFallbackLoader();
            if (resName.startsWith("/")) {
                resName = resName.substring(1);
            }
            List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(resName);
            if (!this.fallbackEnabled.get() || matchingPatterns.isEmpty()) {
                List<Resource> list = Collections.emptyList();
                return list;
            }
            this.findRevisionDynamically(context, matchingPatterns);
            XBundleRevision brev = context.targetRevision;
            if (brev == null) {
                List<Resource> list = Collections.emptyList();
                return list;
            }
            URL resURL = brev.getEntry(resName);
            if (resURL == null) {
                FrameworkLogger.LOGGER.tracef("Cannot load resource [%s] from module: %s", resName, brev);
                List<Resource> list = Collections.emptyList();
                return list;
            }
            List<Resource> list = Collections.singletonList(new URLResource(resURL));
            return list;
        }
        finally {
            this.unlockFallbackLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findRevisionDynamically(DynamicLoadContext context, List<XPackageRequirement> matchingPatterns) {
        AtomicInteger recursiveDepth;
        String pathName = context.resName;
        int idx = pathName.lastIndexOf(47);
        if (idx < 0) {
            return;
        }
        String path = pathName.substring(0, idx);
        if (this.importedPaths.contains(path)) {
            return;
        }
        if (dynamicLoadAttempts == null) {
            dynamicLoadAttempts = new ThreadLocal();
        }
        Map<String, AtomicInteger> mapping = dynamicLoadAttempts.get();
        boolean removeThreadLocalMapping = false;
        try {
            if (mapping == null) {
                mapping = new HashMap<String, AtomicInteger>();
                dynamicLoadAttempts.set(mapping);
                removeThreadLocalMapping = true;
            }
            if ((recursiveDepth = mapping.get(pathName)) == null) {
                recursiveDepth = new AtomicInteger();
                mapping.put(pathName, recursiveDepth);
            }
            if (recursiveDepth.incrementAndGet() == 1) {
                this.findInResolvedRevisions(context, matchingPatterns);
                if (context.targetRevision == null) {
                    this.findInUnresolvedRevisions(context, matchingPatterns);
                    if (context.targetRevision == null) {
                        this.findInSystemRevision(context, matchingPatterns);
                    }
                }
            }
        }
        finally {
            if (removeThreadLocalMapping) {
                dynamicLoadAttempts.remove();
            } else {
                recursiveDepth = mapping.get(pathName);
                if (recursiveDepth.decrementAndGet() == 0) {
                    mapping.remove(pathName);
                }
            }
        }
    }

    private List<XPackageRequirement> findMatchingPatterns(String resName) {
        List<XPackageRequirement> dynamicRequirements = this.getDynamicPackageRequirements((BundleRevision)this.hostRev);
        String pathName = VFSUtils.getPathFromClassName((String)resName);
        List<XPackageCapability> packageCapabilities = this.getPackageCapabilities((BundleRevision)this.hostRev);
        for (XPackageCapability packageCap : packageCapabilities) {
            String packagePath = packageCap.getPackageName().replace('.', '/');
            if (!pathName.equals(packagePath)) continue;
            return Collections.emptyList();
        }
        ArrayList<XPackageRequirement> foundMatch = new ArrayList<XPackageRequirement>();
        for (XPackageRequirement dynreq : dynamicRequirements) {
            String pattern = dynreq.getPackageName();
            if (pattern.equals("*")) {
                foundMatch.add(dynreq);
                continue;
            }
            String patternPath = this.getPatternPath(pattern);
            if (!pathName.startsWith(patternPath)) continue;
            foundMatch.add(dynreq);
        }
        if (!foundMatch.isEmpty()) {
            FrameworkLogger.LOGGER.tracef("Found match for path [%s] with Dynamic-ImportPackage pattern: %s", resName, foundMatch);
        } else {
            FrameworkLogger.LOGGER.tracef("Class [%s] does not match Dynamic-ImportPackage patterns", resName);
        }
        return foundMatch;
    }

    private void findInResolvedRevisions(DynamicLoadContext context, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in resolved modules ...", new Object[0]);
        Set<XBundle> resolved = this.bundleManager.getBundles(36);
        FrameworkLogger.LOGGER.tracef("Resolved modules: %d", resolved.size());
        if (FrameworkLogger.LOGGER.isTraceEnabled()) {
            for (Bundle bundle2 : resolved) {
                FrameworkLogger.LOGGER.tracef("   %s", bundle2);
            }
        }
        if (resolved.isEmpty()) {
            return;
        }
        for (XPackageRequirement xPackageRequirement : matchingPatterns) {
            HashMap<XBundleRevision, XPackageCapability> matches = new HashMap<XBundleRevision, XPackageCapability>();
            for (XBundle bundle3 : resolved) {
                XPackageCapability bcap;
                if (bundle3 == this.hostBundle) continue;
                XBundleRevision brev = bundle3.getBundleRevision();
                if (bundle3.getBundleId() <= 0L || brev.isFragment() || matches.get(brev) != null || (bcap = this.getCapabilityCandidate(context, xPackageRequirement, brev)) == null) continue;
                matches.put(brev, bcap);
            }
            ArrayList matchingRevisions = new ArrayList(matches.keySet());
            if (matchingRevisions.size() <= 0) continue;
            if (matchingRevisions.size() > 1) {
                Collections.sort(matchingRevisions, new Comparator<XBundleRevision>(){

                    @Override
                    public int compare(XBundleRevision brevA, XBundleRevision brevB) {
                        if (brevA.getSymbolicName().equals(brevB.getSymbolicName())) {
                            return brevB.getVersion().compareTo(brevA.getVersion());
                        }
                        return (int)(brevB.getBundle().getBundleId() - brevA.getBundle().getBundleId());
                    }
                });
            }
            XBundleRevision brev = (XBundleRevision)matchingRevisions.get(0);
            context.capability = (XPackageCapability)matches.get(brev);
            context.targetRevision = brev;
            context.requirement = xPackageRequirement;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filterMatches(XPackageRequirement req, XPackageCapability cap) {
        if (!(req instanceof BundleRequirement) || !(cap instanceof BundleCapability)) {
            return true;
        }
        boolean callHookLifecycle = false;
        ResolverHookProcessor hookregs = ResolverHookProcessor.getCurrentProcessor();
        if (hookregs == null) {
            BundleContext syscontext = this.bundleManager.getSystemBundle().getBundleContext();
            hookregs = new ResolverHookProcessor(syscontext, null);
            callHookLifecycle = true;
        }
        if (!hookregs.hasResolverHooks()) {
            return true;
        }
        RemoveOnlyCollection bcaps = new HashSet();
        bcaps.add((BundleCapability)cap);
        bcaps = new RemoveOnlyCollection(bcaps);
        if (callHookLifecycle) {
            try {
                hookregs.begin(Collections.singleton(this.hostRev), null);
                hookregs.filterMatches((BundleRequirement)req, (Collection)bcaps);
            }
            finally {
                hookregs.end();
            }
        } else {
            hookregs.filterMatches((BundleRequirement)req, (Collection)bcaps);
        }
        return bcaps.contains(cap);
    }

    private void findInUnresolvedRevisions(DynamicLoadContext context, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in unresolved modules ...", new Object[0]);
        Set<XBundle> unresolved = this.bundleManager.getBundles(2);
        FrameworkLogger.LOGGER.tracef("Unresolved modules: %d", unresolved.size());
        if (FrameworkLogger.LOGGER.isTraceEnabled()) {
            for (Bundle bundle2 : unresolved) {
                FrameworkLogger.LOGGER.tracef("   %s", bundle2);
            }
        }
        for (Bundle bundle3 : unresolved) {
            if (!(bundle3 instanceof AbstractBundleState)) {
                FrameworkLogger.LOGGER.tracef("Ignore invalid bundle type: %s", bundle3);
                continue;
            }
            FrameworkLogger.LOGGER.tracef("Attempt to resolve: %s", bundle3);
            AbstractBundleState.assertBundleState(bundle3).ensureResolved(false);
        }
        this.findInResolvedRevisions(context, matchingPatterns);
    }

    private void findInSystemRevision(DynamicLoadContext context, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in framework module ...", new Object[0]);
        String resName = context.resName;
        int lastIndex = resName.lastIndexOf(47);
        String pathName = lastIndex > 0 ? resName.substring(0, lastIndex) : resName;
        SystemPaths systemPaths = this.frameworkState.getSystemPathsPlugin();
        if (systemPaths.getSystemPaths().contains(pathName)) {
            context.targetRevision = this.frameworkState.getSystemBundle().getBundleRevision();
        }
    }

    private XPackageCapability getCapabilityCandidate(DynamicLoadContext context, XPackageRequirement pkgreq, XBundleRevision brev) {
        if (brev == this.hostRev) {
            return null;
        }
        String resName = context.resName;
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically [%s] in %s ...", resName, brev);
        URL resURL = brev.getEntry(resName);
        if (resURL == null) {
            return null;
        }
        XPackageCapability cap = this.getCandidateCapability((BundleRevision)brev, pkgreq, resName);
        return cap != null && this.filterMatches(pkgreq, cap) ? cap : null;
    }

    private XPackageCapability getCandidateCapability(BundleRevision brev, XPackageRequirement preq, String resName) {
        int bestIndex = 0;
        XPackageCapability result = null;
        boolean wildcardreq = preq.getPackageName().endsWith("*");
        for (XPackageCapability pcap : this.getPackageCapabilities(brev)) {
            if (!preq.matches((Capability)pcap)) continue;
            FrameworkLogger.LOGGER.tracef("Matching package capability: %s", pcap);
            if (wildcardreq) {
                String capName = pcap.getPackageName().replace('.', '/');
                for (int index = 0; index < Math.min(capName.length(), resName.length()); ++index) {
                    char chres;
                    char chcap = capName.charAt(index);
                    if (chcap != (chres = resName.charAt(index)) || index <= bestIndex) continue;
                    bestIndex = index;
                    result = pcap;
                }
                continue;
            }
            result = pcap;
            break;
        }
        return result;
    }

    private String getPatternPath(String pattern) {
        String patternPath = pattern;
        if (pattern.endsWith(".*")) {
            patternPath = pattern.substring(0, pattern.length() - 2);
        }
        patternPath = patternPath.replace('.', '/');
        return patternPath;
    }

    private List<XPackageCapability> getPackageCapabilities(BundleRevision brev) {
        ArrayList<XPackageCapability> result = new ArrayList<XPackageCapability>();
        for (Capability aux : brev.getCapabilities("osgi.wiring.package")) {
            result.add((XPackageCapability)((XCapability)aux).adapt(XPackageCapability.class));
        }
        return result;
    }

    private List<XPackageRequirement> getDynamicPackageRequirements(BundleRevision brev) {
        ArrayList<XPackageRequirement> result = new ArrayList<XPackageRequirement>();
        for (Requirement aux : brev.getRequirements("osgi.wiring.package")) {
            XRequirement xreq = (XRequirement)aux;
            XPackageRequirement preq = (XPackageRequirement)xreq.adapt(XPackageRequirement.class);
            if (!preq.isDynamic()) continue;
            result.add(preq);
        }
        if (this.weavingImports != null && !this.weavingImports.isEmpty()) {
            result.addAll(this.weavingImports);
        }
        return result;
    }

    class DynamicLoadContext {
        final String resName;
        XBundleRevision targetRevision;
        XPackageRequirement requirement;
        XPackageCapability capability;

        DynamicLoadContext(String resName) {
            this.resName = resName;
        }
    }
}

