/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsImpl;
import org.jboss.osgi.framework.spi.ExecutorServicePlugin;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;

final class FrameworkEventsPlugin
extends ExecutorServicePlugin<FrameworkEvents> {
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();

    FrameworkEventsPlugin() {
        super(IntegrationServices.FRAMEWORK_EVENTS_PLUGIN, "Framework Events Thread");
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkEvents> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.injectedLockManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected FrameworkEvents createServiceValue(StartContext startContext) throws StartException {
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        return new FrameworkEventsImpl((BundleManagerPlugin)this.getBundleManager(), this.getExecutorService(), lockManager);
    }

    @Override
    public void stop(StopContext context) {
        FrameworkEvents events = (FrameworkEvents)this.getValue();
        events.removeAllBundleListeners();
        events.removeAllFrameworkListeners();
        events.removeAllServiceListeners();
    }
}

