/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.modules.ClassSpec;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.filter.PathFilter;
import org.jboss.osgi.framework.internal.LazyActivationTracker;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.internal.WeavingContext;
import org.jboss.osgi.framework.spi.BundleReferenceClassLoader;

final class HostBundleClassLoader
extends BundleReferenceClassLoader<UserBundleState> {
    private final PathFilter lazyFilter;

    private HostBundleClassLoader(ModuleClassLoader.Configuration configuration, UserBundleState bundleState, PathFilter lazyFilter) {
        super(configuration, bundleState);
        this.lazyFilter = lazyFilter;
    }

    public Class<?> loadClassLocal(String className, boolean resolve) throws ClassNotFoundException {
        WeavingContext context = WeavingContext.create((UserBundleState)this.getBundleState());
        try {
            Class clazz = super.loadClassLocal(className, resolve);
            return clazz;
        }
        catch (ClassFormatError cfe) {
            WeavingContext.ContextClass wovenClass = context.getContextClass(className);
            if (wovenClass != null) {
                wovenClass.markComplete();
            }
            throw cfe;
        }
        finally {
            context.close();
        }
    }

    protected void preDefine(ClassSpec classSpec, String className) {
        String path;
        if (((UserBundleState)this.getBundleState()).awaitLazyActivation() && this.lazyFilter.accept(path = className.substring(0, className.lastIndexOf(46)).replace('.', '/'))) {
            LazyActivationTracker.preDefineClass((UserBundleState)this.getBundleState(), className);
        }
    }

    protected void postDefine(ClassSpec classSpec, Class<?> definedClass) {
        String path;
        WeavingContext.ContextClass wovenClass;
        WeavingContext weavingContext = WeavingContext.getCurrentContext();
        if (weavingContext != null && (wovenClass = weavingContext.getContextClass(definedClass.getName())) != null) {
            wovenClass.setProtectionDomain(definedClass.getProtectionDomain());
            wovenClass.setDefinedClass(definedClass);
            wovenClass.markComplete();
        }
        if (((UserBundleState)this.getBundleState()).awaitLazyActivation() && this.lazyFilter.accept(path = definedClass.getPackage().getName().replace('.', '/'))) {
            LazyActivationTracker.postDefineClass((UserBundleState)this.getBundleState(), definedClass);
        }
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class Factory
    implements ModuleClassLoaderFactory {
        private UserBundleState bundleState;
        private PathFilter lazyFilter;

        public Factory(UserBundleState bundleState, PathFilter lazyFilter) {
            this.bundleState = bundleState;
            this.lazyFilter = lazyFilter;
        }

        public ModuleClassLoader create(ModuleClassLoader.Configuration configuration) {
            return new HostBundleClassLoader(configuration, this.bundleState, this.lazyFilter);
        }
    }
}

