/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Stack;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.osgi.framework.Bundle;

final class LazyActivationTracker {
    private static final ThreadLocal<Stack<UserBundleState>> stackAssociation = new ThreadLocal();
    private static final ThreadLocal<UserBundleState> initiatorAssociation = new ThreadLocal();

    LazyActivationTracker() {
    }

    static void startTracking(UserBundleState userBundle, String className) {
        FrameworkLogger.LOGGER.tracef("startTracking %s from: %s", className, userBundle);
        initiatorAssociation.set(userBundle);
    }

    static void processLoadedClass(Class<?> loadedClass) {
        assert (initiatorAssociation.get() != null) : "No activation initiator";
        FrameworkLogger.LOGGER.tracef("processLoadedClass: %s", loadedClass.getName());
        LazyActivationTracker.processActivationStack();
    }

    static void preDefineClass(UserBundleState userBundle, String className) {
        FrameworkLogger.LOGGER.tracef("preDefineClass %s from: %s", className, userBundle);
        LazyActivationTracker.addDefinedClass(userBundle, className);
    }

    static void postDefineClass(UserBundleState userBundle, Class<?> definedClass) {
        FrameworkLogger.LOGGER.tracef("postDefineClass %s from: %s", definedClass.getName(), userBundle);
        if (initiatorAssociation.get() == null) {
            LazyActivationTracker.processActivationStack();
        }
    }

    static void stopTracking(UserBundleState userBundle, String className) {
        FrameworkLogger.LOGGER.tracef("stopTracking %s from: %s", className, userBundle);
        initiatorAssociation.remove();
        stackAssociation.remove();
    }

    private static void addDefinedClass(UserBundleState userBundle, String className) {
        if (userBundle.awaitLazyActivation() && !userBundle.isAlreadyStarting()) {
            Stack<UserBundleState> stack = stackAssociation.get();
            if (stack == null) {
                stack = new Stack();
                stackAssociation.set(stack);
            }
            if (!stack.contains(userBundle)) {
                FrameworkLogger.LOGGER.tracef("addDefinedClass %s from: %s", className, userBundle);
                stack.push(userBundle);
            }
        }
    }

    private static void processActivationStack() {
        Stack<UserBundleState> stack = stackAssociation.get();
        if (stack != null) {
            FrameworkLogger.LOGGER.tracef("processActivationStack: %s", stack);
            while (!stack.isEmpty()) {
                UserBundleState userBundle = stack.pop();
                if (!userBundle.awaitLazyActivation()) continue;
                try {
                    userBundle.activateLazily();
                }
                catch (Throwable th) {
                    FrameworkLogger.LOGGER.errorCannotActivateBundleLazily(th, (Bundle)userBundle);
                }
            }
        }
    }
}

