/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.startlevel.StartLevel;

public final class StartLevelImpl
implements StartLevel {
    private final BundleManager bundleManager;

    public StartLevelImpl(BundleManager bundleManager) {
        this.bundleManager = bundleManager;
    }

    public int getStartLevel() {
        XBundle systemBundle = this.bundleManager.getSystemBundle();
        FrameworkStartLevel fwkStartLevel = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        return fwkStartLevel.getStartLevel();
    }

    public void setStartLevel(int startlevel) {
        XBundle systemBundle = this.bundleManager.getSystemBundle();
        FrameworkStartLevel fwkStartLevel = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        fwkStartLevel.setStartLevel(startlevel, new FrameworkListener[0]);
    }

    public int getInitialBundleStartLevel() {
        XBundle systemBundle = this.bundleManager.getSystemBundle();
        FrameworkStartLevel fwkStartLevel = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        return fwkStartLevel.getInitialBundleStartLevel();
    }

    public void setInitialBundleStartLevel(int startlevel) {
        XBundle systemBundle = this.bundleManager.getSystemBundle();
        FrameworkStartLevel fwkStartLevel = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        fwkStartLevel.setInitialBundleStartLevel(startlevel);
    }

    public int getBundleStartLevel(Bundle bundle2) {
        this.assertValidBaundle(bundle2);
        return ((BundleStartLevel)bundle2.adapt(BundleStartLevel.class)).getStartLevel();
    }

    public void setBundleStartLevel(Bundle bundle2, int startlevel) {
        this.assertValidBaundle(bundle2);
        ((BundleStartLevel)bundle2.adapt(BundleStartLevel.class)).setStartLevel(startlevel);
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle2) {
        this.assertValidBaundle(bundle2);
        return ((BundleStartLevel)bundle2.adapt(BundleStartLevel.class)).isPersistentlyStarted();
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle2) {
        this.assertValidBaundle(bundle2);
        return ((BundleStartLevel)bundle2.adapt(BundleStartLevel.class)).isActivationPolicyUsed();
    }

    private void assertValidBaundle(Bundle bundle2) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        if (bundle2.getState() == 1) {
            throw FrameworkMessages.MESSAGES.illegalStateBundleAlreadyUninstalled(bundle2);
        }
    }
}

