/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.StartLevelManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.spi.AttachmentKey;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;

public final class StartLevelManagerImpl
implements StartLevelManager {
    private static AttachmentKey<BundleStartLevelState> BUNDLE_STARTLEVEL_KEY = AttachmentKey.create(BundleStartLevelState.class);
    private final BundleManagerPlugin bundleManager;
    private final FrameworkEvents events;
    private final ExecutorService executorService;
    private final AtomicBoolean immediateExecution;
    private AtomicInteger initialBundleStartLevel = new AtomicInteger(1);
    private AtomicInteger startLevel = new AtomicInteger(0);
    private AtomicBoolean changingStartLevel = new AtomicBoolean();

    public StartLevelManagerImpl(BundleManager bundleManager, FrameworkEvents frameworkEvents, ExecutorService executorService, AtomicBoolean immediateExecution) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
        this.events = frameworkEvents;
        this.executorService = executorService;
        this.immediateExecution = immediateExecution;
    }

    @Override
    public void enableImmediateExecution(boolean enable) {
        this.immediateExecution.set(enable);
    }

    @Override
    public int getFrameworkStartLevel() {
        return this.startLevel.get();
    }

    @Override
    public synchronized void setFrameworkStartLevel(int level, FrameworkListener ... listeners) {
        this.setFrameworkStartLevelInternal(level, this.immediateExecution.get(), listeners);
    }

    @Override
    public boolean isFrameworkStartLevelChanging() {
        return this.changingStartLevel.get();
    }

    @Override
    public void shutdownFramework(FrameworkListener ... listeners) {
        this.setFrameworkStartLevelInternal(0, true, listeners);
    }

    private synchronized void setFrameworkStartLevelInternal(final int level, boolean synchronous, final FrameworkListener ... listeners) {
        final SystemBundleState sysbundle = this.bundleManager.getSystemBundle();
        if (level == this.getFrameworkStartLevel()) {
            this.events.fireFrameworkEvent(sysbundle, 8, null, listeners);
            return;
        }
        if (level > this.getFrameworkStartLevel()) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoIncreasingStartLevel(StartLevelManagerImpl.this.getFrameworkStartLevel(), level);
                    StartLevelManagerImpl.this.increaseFrameworkStartLevel(level);
                    StartLevelManagerImpl.this.events.fireFrameworkEvent(sysbundle, 8, null, listeners);
                }
            };
            this.executeTask(runner, synchronous);
        } else if (level < this.getFrameworkStartLevel()) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoDecreasingStartLevel(StartLevelManagerImpl.this.getFrameworkStartLevel(), level);
                    StartLevelManagerImpl.this.decreaseFrameworkStartLevel(level);
                    StartLevelManagerImpl.this.events.fireFrameworkEvent(sysbundle, 8, null, listeners);
                }
            };
            this.executeTask(runner, synchronous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void increaseFrameworkStartLevel(int level) {
        try {
            this.changingStartLevel.set(true);
            ArrayList<XBundle> bundles = new ArrayList<XBundle>(this.bundleManager.getBundles());
            Comparator<XBundle> comparator = new Comparator<XBundle>(){

                @Override
                public int compare(XBundle b1, XBundle b2) {
                    return (int)(b1.getBundleId() - b2.getBundleId());
                }
            };
            Collections.sort(bundles, comparator);
            while (this.startLevel.get() < level) {
                this.startLevel.incrementAndGet();
                FrameworkLogger.LOGGER.infoStartingBundlesForStartLevel(this.startLevel.get());
                for (XBundle bundle2 : bundles) {
                    BundleStartLevelState state;
                    if (bundle2.getBundleId() == 0L || bundle2.isFragment() || (state = this.getBundleStartLevelState(bundle2)).getLevel() != this.startLevel.get() || !state.isStarted()) continue;
                    try {
                        int opts = 1;
                        if (this.isBundleActivationPolicyUsed(bundle2)) {
                            opts |= 2;
                        }
                        bundle2.start(opts);
                    }
                    catch (Throwable e) {
                        this.events.fireFrameworkEvent(bundle2, 2, e, new FrameworkListener[0]);
                    }
                }
            }
        }
        finally {
            this.changingStartLevel.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void decreaseFrameworkStartLevel(int level) {
        try {
            this.changingStartLevel.set(true);
            while (this.startLevel.get() > level) {
                FrameworkLogger.LOGGER.infoStoppingBundlesForStartLevel(level);
                ArrayList<XBundle> bundles = new ArrayList<XBundle>(this.bundleManager.getBundles());
                Comparator<XBundle> comparator = new Comparator<XBundle>(){

                    @Override
                    public int compare(XBundle b1, XBundle b2) {
                        return (int)(b1.getBundleId() - b2.getBundleId());
                    }
                };
                Collections.sort(bundles, comparator);
                Collections.reverse(bundles);
                for (XBundle bundle2 : bundles) {
                    BundleStartLevelState state;
                    if (bundle2.getBundleId() == 0L || bundle2.isFragment() || (state = this.getBundleStartLevelState(bundle2)).getLevel() != this.startLevel.get()) continue;
                    try {
                        bundle2.stop(1);
                    }
                    catch (Throwable e) {
                        this.events.fireFrameworkEvent(bundle2, 2, e, new FrameworkListener[0]);
                    }
                }
                this.startLevel.decrementAndGet();
            }
        }
        finally {
            this.changingStartLevel.set(false);
        }
    }

    @Override
    public int getBundleStartLevel(XBundle bundle2) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        return this.getBundleStartLevelState(bundle2).getLevel();
    }

    @Override
    public void setBundleStartLevel(XBundle bundle2, int level) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        if (bundle2.getBundleId() == 0L) {
            throw FrameworkMessages.MESSAGES.illegalArgumentStartLevelOnSystemBundles();
        }
        final XBundle hostBundle = bundle2;
        this.getBundleStartLevelState(bundle2).setLevel(level);
        if (level <= this.getFrameworkStartLevel()) {
            if ((bundle2.getState() & 0x28) > 0) {
                return;
            }
            if (this.isBundlePersistentlyStarted(bundle2)) {
                FrameworkLogger.LOGGER.infoStartingBundleDueToStartLevel((Bundle)hostBundle);
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int opts = 1;
                            if (StartLevelManagerImpl.this.isBundleActivationPolicyUsed(hostBundle)) {
                                opts |= 2;
                            }
                            hostBundle.start(opts);
                        }
                        catch (BundleException e) {
                            StartLevelManagerImpl.this.events.fireFrameworkEvent(hostBundle, 2, e, new FrameworkListener[0]);
                        }
                    }
                };
                this.executeTask(runner, this.immediateExecution.get());
            }
        } else {
            if ((bundle2.getState() & 0x28) == 0) {
                return;
            }
            FrameworkLogger.LOGGER.infoStoppingBundleDueToStartLevel((Bundle)hostBundle);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        hostBundle.stop(1);
                    }
                    catch (BundleException e) {
                        StartLevelManagerImpl.this.events.fireFrameworkEvent(hostBundle, 2, e, new FrameworkListener[0]);
                    }
                }
            };
            this.executeTask(runner, this.immediateExecution.get());
        }
    }

    @Override
    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel.get();
    }

    @Override
    public void setInitialBundleStartLevel(int startlevel) {
        this.initialBundleStartLevel.set(startlevel);
    }

    @Override
    public boolean isBundlePersistentlyStarted(XBundle bundle2) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        return this.getBundleStartLevelState(bundle2).isStarted();
    }

    @Override
    public void setBundlePersistentlyStarted(XBundle bundle2, boolean started) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        this.getBundleStartLevelState(bundle2).setStarted(started);
    }

    @Override
    public boolean isBundleActivationPolicyUsed(XBundle bundle2) {
        boolean result = false;
        if (bundle2 instanceof AbstractBundleState) {
            AbstractBundleState<?> bundleState = AbstractBundleState.assertBundleState((Bundle)bundle2);
            StorageState storageState = bundleState.getStorageState();
            result = storageState.isBundleActivationPolicyUsed();
        }
        return result;
    }

    private BundleStartLevelState getBundleStartLevelState(XBundle bundle2) {
        if (bundle2 instanceof Framework) {
            return new BundleStartLevelState(bundle2);
        }
        BundleStartLevelState state = (BundleStartLevelState)bundle2.getAttachment(BUNDLE_STARTLEVEL_KEY);
        if (state == null) {
            state = new BundleStartLevelState(bundle2);
            bundle2.putAttachment(BUNDLE_STARTLEVEL_KEY, (Object)state);
        }
        return state;
    }

    private void executeTask(Runnable runner, boolean synchronous) {
        if (!this.executorService.isShutdown()) {
            if (synchronous) {
                runner.run();
            } else {
                this.executorService.execute(runner);
            }
        }
    }

    class BundleStartLevelState {
        final XBundle bundle;
        boolean started;
        int level;

        public BundleStartLevelState(XBundle bundle2) {
            this.bundle = bundle2;
            if (bundle2 instanceof UserBundleState) {
                UserBundleState userBundle = (UserBundleState)bundle2;
                StorageState storageState = userBundle.getStorageState();
                this.level = storageState != null ? storageState.getStartLevel() : StartLevelManagerImpl.this.getInitialBundleStartLevel();
            }
        }

        int getLevel() {
            return this.level;
        }

        void setLevel(int level) {
            this.level = level;
            if (this.bundle instanceof UserBundleState) {
                UserBundleState userBundle = (UserBundleState)this.bundle;
                StorageState storageState = userBundle.getStorageState();
                storageState.setStartLevel(level);
            }
        }

        boolean isStarted() {
            return this.started;
        }

        void setStarted(boolean started) {
            this.started = started;
            if (this.bundle instanceof UserBundleState) {
                UserBundleState userBundle = (UserBundleState)this.bundle;
                StorageState storageState = userBundle.getStorageState();
                storageState.setPersistentlyStarted(started);
            }
        }
    }
}

